%  Uebung 23 - Aufgabe 1b
%
%  Loesung des Gleichungssystems 
%-------------------------------------------------------
%
%  Es werden die folgenden Bezeichnungen verwendet:
%  P(x)    -->  x  
%  P(xy)   -->  xy 
%  P(x|y)  -->  x_y
%  etc.

clear all;

syms x y xx xy yx yy x_x x_y y_x y_y

eqns = [... 
x == 3/2*y ... 
xy == yx' ... 
xy + yx == 3 * (xx + yy) ... 
x  + y  == 1 ... 
x_x + y_x  == 1 ... 
x_y + y_y  == 1 ... 
xx == x_x * x ... 
xy == y_x * x ... 
yx == x_y * y ... 
yy == y_y * y]; 

S = solve(eqns, [x y xx xy yx yy x_x x_y y_x y_y]);
    


% Anmerkung:  Die folgende Gleichung wird nicht benoetigt, weil 
% ----------  sie gleich der Summe der 4 letzten Gleichungen ist!
% 'xx + xy + yx + yy = 1' 

disp('Loesung des Gleichungssystems:')
disp(['P(x) = ' char(S.x)])
disp(['P(y) = ' char(S.y)])
disp(['P(xx) = ' char(S.xx)])
disp(['P(xy) = ' char(S.xy)])
disp(['P(yx) = ' char(S.yx)])
disp(['P(yy) = ' char(S.yy)])
disp(['P(x|x) = ' char(S.x_x)])
disp(['P(x|y) = ' char(S.x_y)])
disp(['P(y|x) = ' char(S.y_x)])
disp(['P(y|y) = ' char(S.y_y)])

