function  print_ngram_probs(ngram,maxpr,sstr)
%
%  function  print_ngram_probs(ngram,maxpr,sstr)
%
%  Print probabilites of N-gram 
%  
%  The N-gram probabilities P(vi1|viN,...,vi2) are denoted as 
%  ngram(iN,...,i2,i1),  1 <= i <= vocsize+1, where `vocsize+1` 
%  means the boundary "BND" item that delimits finite-length 
%  sequences.
%
%  Inputs:   ngram     N-gram with model order N = 1, 2 or 3 
%            maxpr     optionally restricts the number of printed 
%                      probabilities if the vocabulary size plus "BND" 
%                      is greater than `maxpr`
%            sstr      optional first word of header line

sz = size(ngram); 
if sz(1) == 1
  N = 1;
  vocsize = sz(2);
  vs1 = vocsize;
  if abs(vocsize - 27) > 2
    error('*** first arg is probably not a korrect unigram')
  end
else
  N = length(sz);
  vs1 = sz(1);
  vocsize = vs1-1;
  if ~all(sz - sz(1) == 0) 
    error('*** first arg is probably not a korrect bigram or trigram')
  end
end

if (nargin < 2) | isempty(maxpr)
  maxpr = vs1;
end
if nargin < 3
  sstr = '';
end

headers = ' ' * ones(28,3);
headers(1:26,3) = ('a':'z')';
headers(27,3) = '-';
headers(28,:) = 'BND';

str = [' model:     voc size = ' num2str(vocsize) ' (plus "BND")'];
if N == 1
  disp([sstr 'unigram' str])
  for ii = 1:maxpr:vs1
    for h = 1:size(headers,1), fprintf(' %6s', char(headers(h,:))); end
    fprintf('\n');
    disp(sprintf(' %6.3f',ngram(ii:min(ii+maxpr-1,vs1))))
  end    
elseif N == 2
  disp([sstr 'bigram' str])
  fprintf('   ');
  for h = 1:size(headers,1), fprintf(' %6s', char(headers(h,:))); end
  fprintf('\n');
  for ii = 1:min(vs1,maxpr)
    fprintf('%s', char(headers(ii,:)));
    disp(sprintf('%7.3f',ngram(ii,1:min(vs1,maxpr))))
  end
  if vs1 > maxpr
    disp(['  (only ' num2str(maxpr) 'x' num2str(maxpr) ...
          ' elements of matrix printed)'])
  end
else 
  disp([sstr 'trigram' str])
  for jj = 1:min(vs1,maxpr)
    fprintf('propabilities for: %s\n   ',char(headers(jj,:)));
    for h = 1:size(headers,1), fprintf(' %6s', char(headers(h,:))); end
    fprintf('\n');
    for ii = 1:min(vs1,maxpr)
      fprintf('%s', char(headers(ii,:)));
      disp(sprintf('%7.3f',ngram(ii,1:min(vs1,maxpr),jj)))
    end
  end
  if vs1 > maxpr
    disp(['  (only ' num2str(maxpr) 'x' num2str(maxpr) 'x' ...
          num2str(maxpr) ' elements of matrix printed)'])
  end
end
