% Test example for Matlab function SOLVE
%--------------------------------------------

% This program provides an example for the usage of Matlab function 
% SOLVE of Symbolic Math Toolbox versions older than 6.1 on the one 
% hand, and for never versions on the other hand.

v = ver('symbolic');
if verLessThan('symbolic', '6.1')
  disp(['*** this is Matlab Symbolic Math Toolbox version ' v.Version])
  disp('    which requires the old syntax of function SOLVE')
  disp('    (please see HELP for more information)')

  % example for Symbolic Math Toolbox versions lower than 6.1 
  clear all;
  syms x y;
  [Sx,Sy] = solve(y == x + 1, ...
                  y == 1 - x);
  disp(['x = ' char(Sx)])
  disp(['y = ' char(Sy)])

else 
   
  % example for Symbolic Math Toolbox versions 6.1 or higher
  disp(['(this is Matlab Symbolic Math Toolbox version ' v.Version ')'])
  clear all;
  syms x y;
  eqns = [y == x + 1, ...
          y == 1 - x];
  S = solve(eqns, [x y]);
  disp(['x = ' char(S.x)])
  disp(['y = ' char(S.y)])

end
