% Uebung 22
%
% Einzelwort-Erkennung mit CDHMM
% -------------------------------------------------------
%
% Uebung 22.2 
%
% Ermitteln der Erkennungsrate
% ----------------------------
%
% UEBUNG 22
%
%
% Aufgabe 2: Ermitteln der Erkennungsrate
%
% a) Schreiben Sie ein Matlab-Skript, das aus den Resultaten des 
%    Erkenners in 'resultat.mat' die Verwechslungsmatrix fuer die 
%    Ziffern ermittelt und darstellt.
%
% b) Ermitteln Sie aus den Resultaten des Erkenners auch die 
%    Erkennungsraten fuer jede der 15 Personen des Test-Sets.


clear all;

if exist('results.mat') ~= 2,
  error(['Datei ''results.mat'' mit den Erkennerresultaten ', ...
         'nicht gefunden']);
end;
load results;
                                     % Namen der HMM laden 
if exist('cdhmms.mat') ~= 2,
  error(['Datei ''cdhmms.mat'' mit den Erkenner-HMM nicht gefunden']);
end;
load cdhmms;
wstr = [];
for i = 1:length(cdhmm)
  words{i} = cdhmm(i).name;
  wstr = [wstr ' ' cdhmm(i).name(1:5)];
end


%----- Verwechslungsmatrix fuellen und in Prozent ausgeben -----

mixup = zeros(length(cdhmm));
for i = 1:size(result,2),
  mixup(result(i).is_word_num,result(i).rec_word_num) = ...
        mixup(result(i).is_word_num,result(i).rec_word_num)+1;
end;

disp(' ');
disp(['Verwechslungsmatrix:   (Angaben in %)']);
disp(' ');
disp(['Wort:  | Erkannt als Wort:']);
disp(['       | ' wstr]);
disp(['-------|-----------------------------------' ... 
                          '---------------------------------']);
k = 1;
for i = 1:length(cdhmm)
  for j = 1:length(cdhmm)
    if j == 1,
      fprintf(1,'%s | ',words{i});
    end
    fprintf(1,'%4d  ',round(mixup(i,j)/max(1,sum(mixup(i,:)))*100));
    if j == length(cdhmm)
      fprintf(1,'%s\n','|')
    end
  end
end
disp(['-------|-----------------------------------' ... 
                          '---------------------------------']);
disp(' ');
disp (['Durchschnittliche Erkennunsrate: ' ...
           num2str(sum(diag(mixup))/size(result,2)*100,3) '%']);


%----- Erkennungsrate fuer jeden Sprecher -----

nsp = 0;                     % hoechste Sprechernummer
for i = 1:size(result,2)
  nsp = max(nsp,result(i).speaker);
end
if nsp == 0
  return
end
  
counter = zeros(1,nsp);      % zaehlt Woerter jedes Sprechers 
correct = zeros(1,nsp);      % zaehlt korrekt erk. Woerter jedes Sprechers 
for i = 1:size(result,2),
  counter(result(i).speaker) = counter(result(i).speaker)+1;
  if result(i).is_word_num == result(i).rec_word_num
    correct(result(i).speaker) = correct(result(i).speaker)+1;
  end
end

disp(' ');
for i = 1:length(counter),
  if counter(i) > 0
    fprintf(1,['Erkennungsrate Sprecher %2d:  %5.1f'], ...
                               [i correct(i)/counter(i)*100]); 
    fprintf(1,'%s   ','%')
    fprintf(1,['(%2d Fehler auf %d Woerter)\n'], ...
                      [counter(i)-correct(i) counter(i)]); 
  end
end
