function  logS = logSum(logX,logY)
%
%  function  logS = logSum(logX,logY)
%
%  Compute the sum s = x+y, whereby x, y and/or s may be very small 
%  so that they can be represented in the log domain only as logX = log(x),
%  logY = log(y) and logS = log(s), resp. Therefore, it is not possible to
%  compute  logS = log(exp(logX)+exp(logY)),  but it is necessary to apply 
%  the Kingsburg-Rayner formula: 
%      logS = logX + log(1 + exp(logY-logX)   if  logX >= logY
%           = logY + log(1 + exp(logX-logY)   else

if (logX == -Inf) & (logY == -Inf)
  logS = -Inf;
else
  if logX >= logY
    logZ1 = logX;
    logZ2 = logY;
  else
    logZ1 = logY;
    logZ2 = logX;
  end
  logS = logZ1 + log(1 + exp(logZ2-logZ1));
end

