function mceps = extr_mel_ceps(x,fs,w,shift,nfilt,ncep)
% 
%  function:  mceps = extr_mel_ceps(x,fs,w,shift,nfilt,ncep)
%
%  inputs:    x       input signal
%             fs      sampling frequency
%             w       window function (discrete)
%             shift   offset in number of samples between consecutive 
%                       analysis windows 
%             nfilt   number of channels in mel filter bank
%             ncep    order of cepstral vector
%
%  outputs:   mceps   array of cepstral vectors with mceps(k,:) 
%                     being the k-th vector and mceps(k,1) is its 
%                     zero quefrency component

x = x(:);          % make column vector
siglen = length(x);
winlen = length(w);

if siglen < winlen 
  error('*** length of signal shorter than analysis window');
end
if (winlen < 1) | (max(abs(w)) == 0)
  error('*** invalid analysis window (zero size or all zeros)');
end
if winlen < ncep
  error(['*** window size must be greater than ncep, i.e. ' num2str(ncep)])
end

numfra = floor((siglen-(winlen-shift))/shift);
mceps = zeros(numfra,ncep);
mfbk = [];

for nfr = 1:numfra;
  ns = (nfr-1)*shift;
  xw = x(ns+1:ns+winlen).*w;               % windowing
  if max(abs(xw)) > 0
    [mc,mfbk] = mfcc(xw,fs,nfilt,ncep,mfbk);
    mceps(nfr,:) = mc';
  end
end


