% Uebung 21
% 
% Trainieren diskreter HMMs mit Baum-Welch-Algorithmus
% ----------------------------------------------------
%
% Uebung 21.3
%
% Testen der trainierten HMM
% --------------------------


% Datenstruktur fuer DDHMM (discrete density HMM)
% -----------------------
%
% N = Anzahl Zustaende des HMM (inkl. Anfangs- und Endzustand)
% M = Anzahl der diskreten Beobachtungen
%
% ddhmm.name    Name des Modells; Lautfolge (character array) 
% ddhmm.a       Zustandsuebergangs-Wahrscheinlichkeiten  (NxN array)
% ddhmm.b       Beobachtungswahrscheinlichkeiten  (NxM array)


clear all;

if exist('ddhmms_trained.mat','file') ~= 2,
  disp(['Datei ''ddhmms_trained.mat'' nicht gefunden.']);
  return;
end;


%----- DDHMM laden -----

load ddhmms.mat;          % Generierende DDHMM --> Variable 'ddhmm'
load ddhmms_trained.mat;  % Trainierte DDHMM   --> Variable 'ddhmm2', 'Ind'
if exist('ddhmm2') ~= 1 | exist('Ind') ~= 1,
  disp(['Es konnten keine trainierten Modelle geladen werden.']);
  disp(['Die Datei ''ddhmms_trained'' muss die trainierten Modelle in ']);
  disp(['einem Array mit Namen ''ddhmm2'' gespeichert haben und ']);
  disp(['die Indizes der verwendeten Modelle im Array ''Ind''']);
  return;
end;


% Generierung von Sequenzen mit den originalen Modellen und 
% Erkennung durch die trainierten Modelle
% (unter Verwendung eines GUIs, analog zu den bisherigen Uebungen)
% ----------------------------------------------------------------

X = [];                  % Beobachtungs-Sequenz
Q = [];                  % Zustands-Sequenz
prVit = [];              % Wahrscheinlichkeit aus Viterbi-Algorithmus
prFwd = [];              % Wahrscheinlichkeit aus Forward-Algorithmus
hFig = [];               % Figure-Handle
cfg.showRecModels = 1;
cfg.showStartStop = 1;


while 1
                       % GUI-Aufruf --> Warten auf aktivierten Button
  [hFig,ButtonPressed] = display_gui(hFig,ddhmm,Ind,X,Q,prFwd,[],prVit,cfg);
  if ButtonPressed == -1,
    break;
  end;

         % Generierendes HMM: Beobachtungs- und Zustandssequenz erzeugen
  [X,Q] = gen_discr_obs_seq(ddhmm(Ind(ButtonPressed)));
    
         % Erkennende HMM: Optimale Zustandssequenzen und zugehoerige
         %                 Wahrscheinlikeiten ermitteln
  prVit = []; 
  optQ = [];
  for n = 1:length(Ind),
    [p,q] = discr_viterbi_alg(ddhmm2(n).a,ddhmm2(n).b,X);
    prVit = [prVit,p];
    optQ = [optQ;q];
  end
    
         % Erkennende HMM: Produktionswahrscheinlichkeiten berechnen
  prFwd = [];
  for n = 1:length(Ind),
    prFwd(n) = discr_forward_alg(ddhmm2(n).a,ddhmm2(n).b,X);
  end
end
