% Uebung 20
%
% Segmentieren und Erkennen diskreter Beobachtungssequenzen mit HMM
% -----------------------------------------------------------------
%
% Uebung 20.3
%
% Vergleichen der Forward- und Viterbi-Wahrscheinlichkeiten
% ---------------------------------------------------------


% Datenstruktur fuer DDHMM (discrete density HMM)
% -----------------------
%
% N = Anzahl Zustaende des HMM (inkl. Anfangs- und Endzustand)
% M = Anzahl der diskreten Beobachtungen
%
% ddhmm.name    Name des Modells; Lautfolge (character array) 
% ddhmm.a       Zustandsuebergangs-Wahrscheinlichkeiten  (NxN array)
% ddhmm.b       Beobachtungswahrscheinlichkeiten  (NxM array)


clear all;


% DDHMMs laden  -->  ddhmm(i), i = 1..9
load('ddhmms');


% Initialisation
X = [];                  % Beobachtungs-Sequenz
Q = [];                  % Zustands-Sequenz
optQ = [];               % Optimale Zustands-Sequenz aus Viterbi-Algorithmus
prVit = [];              % Wahrscheinlichkeit aus Viterbi-Algorithmus
prFwd = [];              % Wahrscheinlichkeit aus Forward-Algorithmus

hFig = [];               % Figure-Handle
SelModels = [1,3,4,6];   % Darzustellende HMM
cfg.showRecModels = 1;
cfg.showStartStop = 1;


while 1,
                        % GUI-Aufruf --> Warten auf aktivierten Button
  [hFig,ButtonPressed] = ... 
       display_gui(hFig,ddhmm,SelModels,X,Q,prFwd,[],prVit,cfg);
  if ButtonPressed == -1,
    break;
  end
  
         % Generierendes HMM: Beobachtungs- und Zustandssequenz erzeugen
  [X,Q,prQ] = gen_discr_obs_seq(ddhmm(SelModels(ButtonPressed)));

         % Erkennende HMM: Optimale Zustandssequenzen und zugehoerige
         %                 Wahrscheinlikeiten ermitteln
  prVit = []; 
  optQ = [];
  for n = 1:length(SelModels),
    [p,q] = discr_viterbi_alg(ddhmm(SelModels(n)).a,ddhmm(SelModels(n)).b,X);
    prVit = [prVit,p];
    optQ = [optQ;q];
  end
    
         % Erkennende HMM: Produktionswahrscheinlichkeiten berechnen
  prFwd = [];
  for n = 1:length(SelModels),
    prFwd(n) = discr_forward_alg(ddhmm(SelModels(n)).a, ...
                                 ddhmm(SelModels(n)).b,X);
  end
end
