% Uebung 20
%
% Segmentieren und Erkennen diskreter Beobachtungssequenzen mit HMM
% -----------------------------------------------------------------
%
% Uebung 20.2
%
% Vergleichen von Zustandssequenzen 
% ---------------------------------
% generierte Zustandssequenz Q versus optimale Zustandssequenz optQ 
% aus dem Viterbi-Algorithmus


% Datenstruktur fuer DDHMM (discrete density HMM)
% -----------------------
%
% N = Anzahl Zustaende des HMM (inkl. Anfangs- und Endzustand)
% M = Anzahl der diskreten Beobachtungen
%
% ddhmm.name    Name des Modells; Lautfolge (character array) 
% ddhmm.a       Zustandsuebergangs-Wahrscheinlichkeiten  (NxN array)
% ddhmm.b       Beobachtungswahrscheinlichkeiten  (NxM array)


clear all;

% Matlab-Funktion fuer Viterbi-Algorithmus vorhanden?
if exist('discr_viterbi_alg') ~= 2,
  disp(['Funktion ''discr_viterbi_alg.m'' nicht gefunden.']);
  return;
end;


% DDHMMs laden  -->  ddhmm(i), i = 1..9
load('ddhmms');


% Initialisation
X = [];                % Beobachtungs-Sequenz
Q = [];                % Zustands-Sequenz
optQ = [];             % Optimale Zustands-Sequenz gemaess Viterbi-Alg.
prVit = [];            % Wahrscheinlichkeit gemaess Viterbi-Algorithmus
hFig = [];             % Figure-Handle
SelModels = [1,2];     % Darzustellende HMM
cfg.showRecModels = 1;
cfg.showStartStop = 1;

while 1,
                     % GUI-Aufruf --> Warten auf aktivierten Button
  [hFig,ButtonPressed] = ...
            display_gui(hFig,ddhmm,SelModels,X,Q,[],optQ,[],cfg);
  if ButtonPressed == -1,
    break;
  end
  
         % Generierendes HMM: Beobachtungs- und Zustandssequenz erzeugen
  [X,Q,prQ] = gen_discr_obs_seq(ddhmm(SelModels(ButtonPressed)));
    
         % Erkennendes HMM: optimale Zustandsseq. und zugeh. Wahrsch. ermitteln
  [prVit,optQ] = discr_viterbi_alg(ddhmm(SelModels(ButtonPressed)).a, ...
                        ddhmm(SelModels(ButtonPressed)).b,X);
end
