% Uebung 20
%
% Segmentieren und Erkennen diskreter Beobachtungssequenzen mit HMM
% -----------------------------------------------------------------
%
% Uebung 20.1
%
% Viterbi-Algorithmus
% -------------------
%
% Dieses Matlab-Skript dient zum Testen des Viterbi-Algorithmus, 
% der als Matlab-Funktion  [p,optQ] = discr_forward_alg(a,b,X) 
% vorliegen muss, mit
%
%   a    Zustandsuebergangswahrscheinlichkeiten eines HMM mit
%          N Zustaenden (NxN-Matrix)
%   b    Beobachtungswahrscheinlichkeiten pro Zustand und 
%          diskrete Beobachtung 1..M (NxM-Matrix)
%   X    Beobachtungssequenz (Vektor mit ganzzahligen Elementen 
%          im Bereich 1..M)
%   p    Produktionswahrscheinlichkeit
%   optQ optimale Zustandssequenz


clear all


% Testdaten:  HMM
                             % 3 Zustaende mit 2 diskreten Beobachtungen
ddhmm(1).a = [0 1.0 0;  0 0.5 0.5;  0 0 0];
ddhmm(1).b = zeros(3,2); 
ddhmm(1).b(2,:) = [0.8 0.2];

                             % 3 Zustaende mit 2 diskreten Beobachtungen
ddhmm(2).a = [0 1.0 0;  0 0.8 0.2;  0 0 0];
ddhmm(2).b = zeros(3,2); 
ddhmm(2).b(2,:) = [0.3 0.7];

                             % 3 Zustaende mit 4 diskreten Beobachtungen
ddhmm(3).a = [0 1.0 0;  0 0.8 0.2;  0 0 0];
ddhmm(3).b = zeros(3,4);
ddhmm(3).b(2,:) = [0.3 0.7 0 0];

                             % 5 Zustaende mit 2 diskreten Beobachtungen
ddhmm(4).a = [0 1.0 0 0 0;  0 0.3 0.7 0 0;  0 0 0.7 0.3 0; ...
              0 0 0 0.7 0.3;  0 0 0 0 0];
ddhmm(4).b = zeros(5,2);
ddhmm(4).b(2,:) = [0.5 0.5];
ddhmm(4).b(3,:) = [0.6 0.4];
ddhmm(4).b(4,:) = [0.2 0.8];

                         % erg. HMM, 4 Zustaende mit 2 diskreten Beobachtungen
ddhmm(5).a = [0 0.1 0.9 0;  0 0 0.5 0.5;  0 0.5 0.3 0.2; 0 0 0 0];
ddhmm(5).b = zeros(4,2); 
ddhmm(5).b(2,:) = [0.5 0.5];
ddhmm(5).b(3,:) = [0.7 0.3];

                         % erg. HMM, 4 Zustaende mit 3 diskreten Beobachtungen
ddhmm(6).a = [0 0.8 0.2 0;  0 0.5 0.3 0.2;  0 0.3 0.6 0.1;  0 0 0 0];
ddhmm(6).b = zeros(4,3); 
ddhmm(6).b(2,:) = [0.2 0.3 0.5];
ddhmm(6).b(3,:) = [0.3 0.4 0.3];


% Testdaten:  Beobachtungssequenzen

X{1}{1} = [1];                 % Beobachtungssequenz 1 fuer Modell 1
X{1}{2} = [1 1];               % Beobachtungssequenz 2 fuer Modell 1
X{1}{3} = [2 2 1];
X{1}{4} = [2 2 1 1 2];

X{2}{1} = [1];
X{2}{2} = [1 2];
X{2}{3} = [2 2 1];
X{2}{4} = [2 2 2];

X{3}{1} = [1];
X{3}{2} = [1 2];
X{3}{3} = [1 2 3];
X{3}{4} = [2 2 2 4];

X{4}{1} = [1 1];
X{4}{2} = [1 1 1];
X{4}{3} = [1 2 1 1];
X{4}{4} = [2];

X{5}{1} = [1];
X{5}{2} = [1 1];
X{5}{3} = [1 2];
X{5}{4} = [1 1 1];

X{6}{1} = [1];
X{6}{2} = [1 2];
X{6}{3} = [1 2 3];
X{6}{4} = [1 1 1];


% Validierungsdaten

p(1,1) = 0.4;                   % Modell 1, Beobachtungssequenz 1
p(1,2) = 0.16;                  %           Beobachtungssequenz 2
p(1,3) = 0.004;                 %           Beobachtungssequenz 3
p(1,4) = 0.00016;

optQ{1}{1} = [1  2  3];
optQ{1}{2} = [1  2  2  3];
optQ{1}{3} = [1  2  2  2  3];
optQ{1}{4} = [1  2  2  2  2  2  3];

p(2,1) = 0.06;
p(2,2) = 0.0336;
p(2,3) = 0.018816;
p(2,4) = 0.043904;

optQ{2}{1} = [1  2  3];
optQ{2}{2} = [1 2 2 3];
optQ{2}{3} = [1  2  2  2  3];
optQ{2}{4} = [1  2  2  2  3];

p(3,1) = 0.06;
p(3,2) = 0.0336;
p(3,3) = 0;
p(3,4) = 0;

optQ{3}{1} = [1 2 3];
optQ{3}{2} = [1  2  2  3];
optQ{3}{3} = [];
optQ{3}{4} = [];

p(4,1) = 0;
p(4,2) = 0.00378;
p(4,3) = 0.0010584;
p(4,4) = 0;

optQ{4}{1} = [];
optQ{4}{2} = [1  2  3  4  5];
optQ{4}{3} = [1  2  3  3  4  5];
optQ{4}{4} = [];

p(5,1) = 0.126;
p(5,2) = 0.07875;
p(5,3) = 0.07875;
p(5,4) = 0.0165375;

optQ{5}{1} = [1  3  4];
optQ{5}{2} = [1  3  2  4];
optQ{5}{3} = [1  3  2  4];
optQ{5}{4} = [1  3  3  2  4];

p(6,1) = 0.032;
p(6,2) = 0.0048;
p(6,3) = 0.0012;
p(6,4) = 0.00032;

optQ{6}{1} = [1  2  4];
optQ{6}{2} = [1  2  2  4];
optQ{6}{3} = [1  2  2  2  4];
optQ{6}{4} = [1  2  2  2  4];


% Testlauf

if exist('discr_viterbi_alg') ~= 2
  disp(['Datei ''discr_viterbi_alg.m'' nicht gefunden.']);
  return;
end;

tolerance = 1e-6;

for k = 1:length(ddhmm),
  disp(['Test mit HMM' num2str(k) ':'])
  for i = 1:length(p(k,:)),
    p_ref = p(k,i);
    optQ_ref = optQ{k}{i};
    [p_tst,optQ_tst] = discr_viterbi_alg(ddhmm(k).a,ddhmm(k).b,X{k}{i});
    if abs(p_tst-p_ref)/(p_ref+(p_ref==0)) > tolerance | ...
           length(optQ_tst) ~= length(optQ_ref) | ...
           sum(abs(optQ_tst-optQ_ref)) > 0,
      disp(['Fehler mit HMM ' num2str(k) ' und Beobachtungssequenz ' ...
            num2str(i) ':']);
      disp(['Wahrscheinlichkeit']);
      disp(['  vorgegeben: ' num2str(p_ref,10)]);
      disp(['  berechnet:  ' num2str(p_tst,10)]);
      disp(['Optimale Zustandssequenz']);
      disp(['  vorgegeben: [' num2str(optQ_ref) ']']);
      disp(['  berechnet:  [' num2str(optQ_tst) ']']);
      return;
    end;
  end;
end;
disp('Test ok');

