function  x = gen_discr_obs(b)
%
%  function:  x = gen_discr_obs(b)
% 
%  Generate one discrete observation `x` from the discrete probability 
%  density function `b` as given by a hidden Markov model. If `b` contains
%  k elements, the outcom of `x` is between 1 and k. The tossing is 
%  simulated with the Matlab random generator 

% test input argument 

if nargin ~= 1,
  error('*** wrong number of input arguments');
end;
cs = cumsum(b);
if abs(cs(end)-1) > 0.00001 
  error('*** integral of probability density function not = 1')
end

% generate random observation according to the discrete probability function

r = rand(1);
x = 1;
while r > cs(x)
  x = x+1;
end;

