% Uebung 19
%
% Generieren und Erkennen diskreter Beobachtungssequenzen mit HMM
% ---------------------------------------------------------------
%
% Uebung 19.3
%
% Generieren von Beobachtungssequenzen und Erkennen derselben mit 
% dem Forward-Algorithmus
% ---------------------------------------------------------------


% Datenstruktur fuer DDHMM (discrete density HMM)
% -----------------------
%
% N = Anzahl Zustaende des HMM (inkl. Anfangs- und End-Zustand)
% M = Anzahl der diskreten Beobachtungen
%
% ddhmm.name    Name des Modells; Lautfolge (character array) 
% ddhmm.a       Zustandsuebergangs-Wahrscheinlichkeiten  (NxN array)
% ddhmm.b       Beobachtungswahrscheinlichkeiten  (NxM array)


clear all;


% DDHMMs laden  -->  ddhmm(i), i = 1..9
load('ddhmms');


% Initialisation
X = [];                       % Beobachtungssequenz
Q = [];                       % Zustandssequenz
hFig = [];                    % Figure Handle
SelectedModels = [1,2,4];     % ausgewaehlte HMM
Pr = [];                      % Wahrscheinlichkeiten aus dem Forward-Alg.
cfg.showRecModels = 1;
cfg.showStartStop = 1;


while 1,                      % GUI-Aufruf --> Warten auf aktivierten Button
  [hFig,ButtonPressed] = ... 
        display_gui(hFig,ddhmm,SelectedModels,X,Q,Pr,[],[],cfg);
  if ButtonPressed < 0,
    break;
  end;
  
            % Beobachtungs- und Zustandssequenz fuer gewaehltes HMM erzeugen
  [X,Q] = gen_discr_obs_seq(ddhmm(SelectedModels(ButtonPressed)));
  
                    % Produktionswahrsch. fuer die erkennenden HMM berechnen
  Pr = [];
  for n = 1:length(SelectedModels),
    Pr(n) = discr_forward_alg(ddhmm(SelectedModels(n)).a, ...
                              ddhmm(SelectedModels(n)).b,X);
  end;
end;

