% Uebung 19
%
% Generieren und Erkennen diskreter Beobachtungssequenzen mit HMM
% ---------------------------------------------------------------
%
% Uebung 19.2
%
% Forward-Algorithums
% -------------------
%
% Dieses Matlab-Skript dient zum Testen des Forward-Algorithmus, 
% der als Matlab-Funktion  p = discr_forward_alg(a,b,X) vorliegen 
% muss, wobei
%
%   a    Zustandsuebergangswahrscheinlichkeiten eines HMM mit
%          N Zustaenden (NxN-Matrix)
%   b    Beobachtungswahrscheinlichkeiten pro Zustand und 
%          diskrete Beobachtung 1..M (NxM-Matrix)
%   X    Beobachtungssequenz (Vektor mit ganzzahligen Elementen 
%          im Bereich 1..M)
%   p    Produktionswahrscheinlichkeit


clear all


% Testdaten:  HMM
                             % 3 Zustaende mit 2 diskreten Beobachtungen
ddhmm(1).a = [0 1.0 0;  0 0.5 0.5;  0 0 0];
ddhmm(1).b = zeros(3,2); 
ddhmm(1).b(2,:) = [0.8 0.2];

                             % 3 Zustaende mit 2 diskreten Beobachtungen
ddhmm(2).a = [0 1.0 0;  0 0.8 0.2;  0 0 0];
ddhmm(2).b = zeros(3,2); 
ddhmm(2).b(2,:) = [0.3 0.7];

                             % 3 Zustaende mit 4 diskreten Beobachtungen
ddhmm(3).a = [0 1.0 0;  0 0.8 0.2;  0 0 0];
ddhmm(3).b = zeros(3,4);
ddhmm(3).b(2,:) = [0.3 0.7 0 0];

                             % 5 Zustaende mit 2 diskreten Beobachtungen
ddhmm(4).a = [0 1.0 0 0 0;  0 0.3 0.7 0 0;  0 0 0.7 0.3 0; ...
              0 0 0 0.7 0.3;  0 0 0 0 0];
ddhmm(4).b = zeros(5,2);
ddhmm(4).b(2,:) = [0.5 0.5];
ddhmm(4).b(3,:) = [0.6 0.4];
ddhmm(4).b(4,:) = [0.2 0.8];

                         % erg. HMM, 4 Zustaende mit 2 diskreten Beobachtungen
ddhmm(5).a = [0 0.1 0.9 0;  0 0 0.5 0.5;  0 0.5 0.3 0.2; 0 0 0 0];
ddhmm(5).b = zeros(4,2); 
ddhmm(5).b(2,:) = [0.5 0.5];
ddhmm(5).b(3,:) = [0.7 0.3];

                         % erg. HMM, 4 Zustaende mit 3 diskreten Beobachtungen
ddhmm(6).a = [0 0.8 0.2 0;  0 0.5 0.3 0.2;  0 0.3 0.6 0.1;  0 0 0 0];
ddhmm(6).b = zeros(4,3); 
ddhmm(6).b(2,:) = [0.2 0.3 0.5];
ddhmm(6).b(3,:) = [0.3 0.4 0.3];


% Testdaten:  Beobachtungssequenzen

X{1}{1} = [1];                 % Beobachtungssequenz 1 fuer Modell 1
X{1}{2} = [1 1];               % Beobachtungssequenz 2 fuer Modell 1
X{1}{3} = [2 2 1];
X{1}{4} = [2 2 1 1 2];

X{2}{1} = [1];                 % Beobachtungssequenz 1 fuer Modell 2
X{2}{2} = [1 2];               % Beobachtungssequenz 2 fuer Modell 2
X{2}{3} = [2 2 1];
X{2}{4} = [2 2 2];

X{3}{1} = [1];
X{3}{2} = [1 2];
X{3}{3} = [1 2 3];
X{3}{4} = [2 2 2 4];

X{4}{1} = [1 1];
X{4}{2} = [1 1 1];
X{4}{3} = [1 2 1 1];
X{4}{4} = [2];

X{5}{1} = [1];
X{5}{2} = [1 1];
X{5}{3} = [1 2];
X{5}{4} = [1 1 1];

X{6}{1} = [1];
X{6}{2} = [1 2];
X{6}{3} = [1 1 1];
X{6}{4} = [1 2 3];


% Validierungsdaten

p(1,1) = 0.4;          % Modell 1, Beobachtungssequenz 1
p(1,2) = 0.16;         %           Beobachtungssequenz 2
p(1,3) = 0.004;        %           Beobachtungssequenz 3
p(1,4) = 0.00016;

p(2,1) = 0.06;
p(2,2) = 0.0336;
p(2,3) = 0.018816;
p(2,4) = 0.043904;

p(3,1) = 0.06;
p(3,2) = 0.0336;
p(3,3) = 0;
p(3,4) = 0;

p(4,1) = 0;
p(4,2) = 0.00378;
p(4,3) = 0.0019782;
p(4,4) = 0;

p(5,1) = 0.151;
p(5,2) = 0.10871;
p(5,3) = 0.09159;
p(5,4) = 0.0360416;

p(6,1) = 0.038;
p(6,2) = 0.00924;
p(6,3) = 0.0013244;
p(6,4) = 0.0033474;


% Testlauf

if exist('discr_forward_alg') ~= 2,
  disp(['Datei ''discr_forward_alg'' nicht gefunden.']);
  return;
end;

tolerance = 1e-6;

% Testen der Produktionswahrscheinlichkeit

for k = 1:length(ddhmm), 
  disp(['Test mit HMM' num2str(k) ':'])
  for i = 1:length(p(k,:)),
    X_used = X{k}{i};       % fuer den Test gebrauchte Beobachtungssequenz
    p_ref = p(k,i);
    p_tst = discr_forward_alg(ddhmm(k).a,ddhmm(k).b,X_used);
    if abs(p_tst-p_ref)/(p_ref+(p_ref==0)) > tolerance
      disp(['Fehler mit HMM ' num2str(k) ' und Beobachtungssequenz ' ...
            num2str(i) ':']);
      disp(['  p vorgegeben: ',num2str(p_ref,10)]);
      disp(['  p berechnet:  ',num2str(p_tst,10)]);
      return;
    end;
  end;
end;

% Testen der Vorwaertswahrscheinlichkeits-Matrix alpha 
% (falls die Funktion 2 Ausgabeargumente hat)

try
  [p_tst,alpha_tst] = discr_forward_alg(ddhmm(6).a,ddhmm(6).b,X_used);

  alpha_ref = [0  0.1600    0.0600    0; ...
               0  0.0294    0.0336    0; ...
               0  0.01239   0.008694  0];
  if any(size(alpha_tst) ~= size(alpha_ref))
    disp(['Fehler mit HMM 6 und Beobachtungssequenz 3:  ' ... 
          'alpha muss eine ' num2str(size(alpha_ref,1)) 'x' ...
                             num2str(size(alpha_ref,2)) ' Matrix sein'])
    return;
  end
  if any(any(abs(alpha_tst-alpha_ref) > tolerance))
    disp(['Fehler mit HMM ' num2str(length(ddhmm)) ...
          ' und Beobachtungssequenz ' num2str(length(X{length(ddhmm)})) ':'])
    str = {'  alpha vorgegeben: ', ...
           '  alpha berechnet:  ', ...
           '                    '};
    for k = 1:2
      if k == 1
        alph = alpha_ref;
      else
        alph = alpha_tst;
      end
      ss = str{k};
      for i = 1:size(alpha_ref,1)
        fprintf(2,'%s',ss)
        for j = 1:size(alpha_ref,2)
          fprintf(2,' %8.5f',alph(i,j))
        end
        fprintf(2,'\n')
        ss = str{3};
      end
    end
  end
catch
end

disp(['Test ok']);
