% Uebung 19
%
% Generieren und Erkennen diskreter Beobachtungssequenzen mit HMM
% ---------------------------------------------------------------
%
% Uebung 19.1
%
% Sequenzen generieren
% --------------------
% mit Links-rechts-HMM und mit ergodischem HMM


% Datenstruktur fuer DDHMM (discrete density HMM)
% -----------------------
%
% N = Anzahl Zustaende des HMM (inkl. Anfangs- und Endzustand)
% M = Anzahl der diskreten Beobachtungen
%
% ddhmm.name    Name des Modells; Lautfolge (character array) 
% ddhmm.a       Zustandsuebergangs-Wahrscheinlichkeiten  (NxN array)
% ddhmm.b       Beobachtungswahrscheinlichkeiten  (NxM array)


clear all;

% DDHMMs laden  -->  ddhmm(i), i = 1..9
load('ddhmms');


% Initialisation
X = [];                       % Beobachtungssequenz
Q = [];                       % Zustandssequenz
hFig = [];                    % Figure Handle
SelectedModels = [1,2,3,5];   % ausgewaehlte HMM
cfg.showRecModels = 0;
cfg.showStartStop = 0;

while 1,
  % GUI-Aufruf --> Warten auf aktivierten Button
  [hFig,ButtonPressed] = ... 
        display_gui(hFig,ddhmm,SelectedModels,X,Q,[],[],[],cfg);
  if ButtonPressed < 0
    break;
  end;
  
  % Beobachtungs- und Zustandssequenz fuer das gewaehlte HMM erzeugen
  [X,Q] = gen_discr_obs_seq(ddhmm(SelectedModels(ButtonPressed)));
end;
