function  [X,Q,p] = gen_discr_obs_seq(hmm)
%
%  funcrtion:  [X,Q,p] = gen_discr_obs_seq(hmm)
%
%  Use discrete HMM `hmm` to generate a sequence of observations. 
%  The probability of the generated sequence is returned in `p`.


if nargin ~= 1,                            % check input arguments
  error('*** incorrect number of input arguments');
end;
if (isfield(hmm,'a') == 0 | isfield(hmm,'b') == 0),
  error('*** input `hmm` does not have fields named ''a'' or ''b'' ');
end;


a = hmm.a;
b = hmm.b;
endstate = size(a,1);

%----- generate the state sequence -----

Q(1) = 1;                        % starting state
t = 1;                           % starting time
while Q(t) ~= endstate
  t = t+1;
  Q(t) = nextstate(a(Q(t-1),:) );
end;

%----- generate observation sequence and evaluate its probability -----

p = a(Q(1),Q(2));                            % (initialization)
for t = 2:(length(Q)-1);
  x = gen_discr_obs(b(Q(t),:));
  r(t-1) = b(Q(t),x);
  X(:,t-1) = x;
  p = p*r(t-1)*a(Q(t),Q(t+1));
end;

%----------------- local function ----------------------------

function  stat = nextstate(tr_probs)

cs = cumsum(tr_probs);
if abs(cs(end)-1) > 0.00001 
  error('*** sum of transition probabilities not = 1')
end;
r = rand;
stat = 1;
while r > cs(stat)
  stat = stat+1;
end;
