function trimtreeplot(p,descb,descl,c,d)
% TRIMTREEPLOT  A modified standard function TREEPLOT. 
%  
% trimtreeplot(p, descb, descl, c, d);
%
%   Plots the leaves differently from TREEPLOT. They appear in their
%   respective layer instead of the deepest layer so that the tree appears
%   as "trimmed". The format is the same as for TREEPLOT, see below.
%   
%   p      tree   
%   descb  text at bottom of leaves 
%   descl  text at top left of leaves
%   c      node specification (see below)
%   d      edge specification (see below)
%  
% TREEPLOT Plot picture of tree.
%   TREEPLOT(p) plots a picture of a tree given a vector of
%   parent pointers, with p(i) == 0 for a root. 
%
%   TREEPLOT(P,nodeSpec,edgeSpec) allows optional parameters nodeSpec
%   and edgeSpec to set the node or edge color, marker, and linestyle.
%   Use '' to omit one or both.
%
%   See also ETREE, TREELAYOUT, ETREEPLOT.

%   Copyright (c) 1984-98 by The MathWorks, Inc.
%   $Revision: 5.8 $  $Date: 1997/11/21 23:44:59 $
%
%   HR, Modifications: *) trimtreelayout instead of TREELAYOUT 
%                      *) print numbers and text at nodes
  
% RG use another treelayout 
%[x,y,h]=treelayout(p);
[x,y,h]=trimtreelayout(p);

f = find(p~=0);
pp = p(f);
X = [x(f); x(pp); repmat(NaN,size(f))];
Y = [y(f); y(pp); repmat(NaN,size(f))];
X = X(:);
Y = Y(:);

if nargin <= 3,
    n = length(p);
    if n < 500,
        plot(x, y, 'ro', X, Y, 'r-');
		  for i=1:length(p),
			 % top right
			 text(x(i)+0.005, y(i)+0.02, num2str(i));
			 % top left
			 if (nargin > 2) && ~isempty(descl{i}),
				text(x(i)-0.005, y(i)+0.02, char(descl{i}), ...
					  'HorizontalAlignment','right');
			 end
			 % bottom center
			 if (nargin > 1) && ~isempty(descb{i}),
				text(x(i), y(i)-0.04, char(descb{i}), ...
					  'HorizontalAlignment','center');
			 end
		  end
    else,
        plot (X, Y, 'r-');
    end;
else,
    [ignore, clen] = size(c);
    if nargin < 3, 
        if clen > 1, 
            d = [c(1:clen-1) '-']; 
        else,
            d = 'r-';
        end;
    end;
    [ignore, dlen] = size(d);
    if clen>0 & dlen>0
        plot (x, y, c, X, Y, d);
    elseif clen>0,
        plot (x, y, c);
    elseif dlen>0,
        plot (X, Y, d);
    else
    end;
end;
%xlabel(['height = ' int2str(h)]);
axis([0 1 0 1]);
