function test_phrasing(sent_num,vers)
%
%  Test function for phrasing implementation
%
%  Allows to call the phrasing subsystem for one of the
%  example sentences provided.
%
%  Requires accentuation to function properly first!
%
%  Inputs:  sent_num  number of the sentence to test (1 ... 10)
%           vers      optional argument that allows to select among 
%                     different versions of the phrasing function;
%                     for `vers` = 'xyz' function phrasing_xyz.m
%                     is selected
 
% check whether the selected function is available
phras_funct_nam = 'phrasing';
if nargin == 2
  phras_funct_nam = [phras_funct_nam '_' vers];
end
if ~exist(phras_funct_nam)
  error(['*** function not found:  ' phras_funct_nam])
end

% check whether an accentuation function is available
acc_funct_nam = '';
if exist('accentuation')
  acc_funct_nam = 'accentuation';
end
if isempty(acc_funct_nam)
  disp('function not found:  accentuation')
  if exist('accentuation_frame')
    ans = input(['do you want to use  accentuation_frame' ...
                 '  instead?  (Y/n)  >> '],'s');
    if isempty(ans) || ans ~= 'n'
      acc_funct_nam = 'accentuation_frame';
    end
  end
end
if isempty(acc_funct_nam)
  if exist('accentuation_sol')
    ans = '';
    ans = input(['or do you want to use  accentuation_sol' ...
                 '  instead?  (Y/n)  >> '],'s');
    if isempty(ans) || ans ~= 'n'
      acc_funct_nam = 'accentuation_sol';
    end
  end
end
if isempty(acc_funct_nam)
  disp('(program aborted)')
  return
end

% if sentence number not provided, prompt for sentence number
if nargin == 0
  sent_num = [];
  while isempty(sent_num)
    sent_num = input('Choose a test sentence (1 ... 10)  >> ');
  end
end

% search for the syntax tree file (.ast) 
astfln = ['satz' num2string(sent_num,2) '.ast'];
fln = astfln;
if ~exist(fln,'file')
  fln = [ 'saetze/' fln];
  if ~exist(fln,'file') 
    fln = [ 'Gegebenes/' fln ];
    if exist(fln,'file') ~= 2
      error(['Cannot find preprocessed syntax tree file: ' astfln]);
    end
  end
end

% read the complete file
fid = fopen(fln);
if fid < 0
  error([' Cannot open syntax tree file ' fln]);
end
asttxt = char(fread(fid))';
fclose(fid);

% feed it to the accentuation and phrasing
tree = read_syntphol(asttxt);
eval(['tree = ' acc_funct_nam '(tree);']);
eval(['[phrbnd,phrtypes] = ' phras_funct_nam '(tree);']);
