function test_accentuation(sent_num,vers)
%
%  Test function for accentuation implementation
%
%  Allows to call the accentuation subsystem for one of the
%  example sentences provided.
%
%  Inputs:  sent_num  number of the sentence to test (1 ... 10)
%           vers      optional argument that allows to select among 
%                     different versions of the accentuation function;
%                     for `vers` = 'xyz' function accentuation_xyz.m
%                     is selected

% check whether the selected function is available
acc_funct_nam = 'accentuation';
if nargin == 2
  acc_funct_nam = [acc_funct_nam '_' vers];
end
if ~exist(acc_funct_nam)
  error(['*** function not found:  ' acc_funct_nam])
end

% if sentence number not provided, prompt for sentence number
if nargin == 0
  sent_num = [];
  while isempty(sent_num)
    sent_num = input('Choose a test sentence (1 ... 10)  >> ');
  end
end

% search for the syntax tree file (.ast) 
astfln = ['satz' num2string(sent_num,2) '.ast'];
fln = astfln;
if ~exist(fln,'file')
  fln = [ 'saetze/' fln];
  if ~exist(fln,'file') 
    fln = [ 'Gegebenes/' fln ];
    if exist(fln,'file') ~= 2
      error(['Cannot find preprocessed syntax tree file: ' astfln]);
    end
  end
end

% read the complete file
fid = fopen(fln);
if fid < 0
  error([' Cannot open syntax tree file ' fln]);
end
asttxt = char(fread(fid))';
fclose(fid);

% and feed it to the accentuation
eval([acc_funct_nam '(read_syntphol(asttxt));']);
