function t = syllable_has_properties (F,property)
%
% t = syllable_has_properties(F,property);
%
% Teste die Silbe in den Trainingsdaten auf die Eigenschaft 'property'.
%
% Moegliche Eigenschaften sind: 
%        'nucleus_close_vowel'      (Silbenkern geschlossener Vokal)
%        'nucleus_open_vowel'       (Silbenkern offener Vokal)
%        'nucleus_front_vowel'      (Silbenkern vorne artikulierter Vokal)
%        'nucleus_long_vowel'       (Silbenkern Langvokal)
%        'nucleus_short_vowel'      (Silbenkern Kurzvokal)
%        'nucleus_schwa'            (Silbenkern Schwa-Laut)
%        'coda_is_voiced'           (Silbenkoda stimmhaft)
%        'onset_is_voiced'          (Silbenansatz stimmhaft)
%        'coda_is_unvoiced'         (Silbenkoda stimmlos)
%        'onset_is_unvoiced'        (Silbenansatz stimmlos)
%        'accent_1'                 (Silbe hat Akzent 1. Grades / Hauptakzent
%        'accent_2'                 (Silbe hat Akzent 2. Grades)
%        'accent_3'                 (Silbe hat Akzent 3. Grades)
%        'accent_4'                 (Silbe hat Akzent 4. Grades)
%        'accent_0'                 (Silbe hat keinen Akzent)
%        'no_phrase_bnd'            (keine Phrasengrenze folgt auf Silbe)
%        'phrase_bnd_0'             (Phrasengrenze 0 folgt auf Silbe)
%        'phrase_bnd_1'             (Phrasengrenze 1 folgt auf Silbe)
%        'phrase_bnd_2'             (Phrasengrenze 2 folgt auf Silbe)
%        'terminal_phrase'          (Silbe in einer Terminalphrase)
%        'progredient_phrase'       (Silbe in einer progredienten Phrase)
%        'phrase_length_1'          (Silbe in einer einsilbigen Phrase)
%        'phrase_length_2'          (Silbe in einer zweisilbigen Phrase)
%        'phrase_length_3-4'        (Silbe in einer 3-4-silbigen Phrase)
%        'phrase_length_5-7'        (Silbe in einer 5-7-silbigen Phrase)
%        'phrase_length_other'      (Silbe in einer 8 oder mehrsilbigen Phrase)




Properties = {'nucleus_close_vowel'; 'nucleus_open_vowel'; 'nucleus_front_vowel'; 'nucleus_long_vowel';...
     'nucleus_schwa'; 'coda_is_voiced'; 'onset_is_voiced'; 'coda_is_unvoiced'; ...
     'nucleus_short_vowel';...
     'onset_is_unvoiced'; 
     'accent_0'; ...
     'accent_1'; ...
     'accent_2'; ...
     'accent_3'; ...     
     'accent_4'; ...    
     'phrase_bnd_0'; ...    
     'phrase_bnd_1'; ...    
     'phrase_bnd_2'; ...    
     'no_phrase_bnd'; ...    
     'terminal_phrase'; ...
     'progredient_phrase'; ...
     'phrase_length_1'; ...         
     'phrase_length_2'; ...              
     'phrase_length_3-4'; ...              
     'phrase_length_5-7'; ...              
     'phrase_length_other'; ...                   
    };


        
if ~ismember(property,Properties), 
   error(['Invalid syllable property <' char(property) '>!']);
end

nucleusIndexes = find(phone_has_properties(F, 'nucleus')); % indices of syllable nuclei

  %% nucleus properties
  if strmatch(property,'nucleus_close_vowel'),
    t = phone_has_properties(F.phone_id(nucleusIndexes,:), 'close_vowel');       
  elseif strmatch(property,'nucleus_open_vowel'),
    t = phone_has_properties(F.phone_id(nucleusIndexes,:), 'open_vowel');
  elseif strmatch(property,'nucleus_front_vowel'),
    t = phone_has_properties(F.phone_id(nucleusIndexes,:), 'front_vowel');
  elseif strmatch(property,'nucleus_long_vowel'),
    t = phone_has_properties(F.phone_id(nucleusIndexes,:), 'long_vowel');
  elseif strmatch(property,'nucleus_short_vowel'),
    t = phone_has_properties(F.phone_id(nucleusIndexes,:), 'short_vowel');    
  elseif strmatch(property,'nucleus_schwa'),
    t = phone_has_properties(F.phone_id(nucleusIndexes,:), 'schwa');
    
    %% onset and coda properties
  elseif strmatch(property,'coda_is_voiced'),    
      t = phone_has_properties(F, 'next_phone_is_voiced');
      t = t(nucleusIndexes); 
  elseif strmatch(property,'onset_is_voiced'),
      t = phone_has_properties(F, 'previous_phone_is_voiced');
      t = t(nucleusIndexes); 
  elseif strmatch(property,'coda_is_unvoiced'),
      t = phone_has_properties(F, 'next_phone_is_unvoiced');
      t = t(nucleusIndexes); 
  elseif strmatch(property,'onset_is_unvoiced'),
      t = phone_has_properties(F, 'previous_phone_is_unvoiced');
      t = t(nucleusIndexes); 
      
      %% accents
  elseif strcmp(property,'accent_0') == 1
    t = phone_has_properties(F.accent(nucleusIndexes), 'accent_0');   
  elseif strcmp(property,'accent_1') == 1
    t = phone_has_properties(F.accent(nucleusIndexes), 'accent_1'); 
  elseif strcmp(property,'accent_2') == 1
    t = phone_has_properties(F.accent(nucleusIndexes), 'accent_2');
  elseif strcmp(property,'accent_3') == 1
    t = phone_has_properties(F.accent(nucleusIndexes), 'accent_3');
  elseif strcmp(property,'accent_4') == 1
    t = phone_has_properties(F.accent(nucleusIndexes), 'accent_4');
    
    % phrase boundaries
  elseif strcmp(property,'phrase_bnd_0') == 1
    t = phone_has_properties(F.phrase_boundary(nucleusIndexes), 'phrase_bnd_0');
  elseif strcmp(property,'phrase_bnd_1') == 1
    t = phone_has_properties(F.phrase_boundary(nucleusIndexes), 'phrase_bnd_1');
  elseif strcmp(property,'phrase_bnd_2') == 1
    t = phone_has_properties(F.phrase_boundary(nucleusIndexes), 'phrase_bnd_0');
  elseif strcmp(property,'no_phrase_bnd') == 1
    t = phone_has_properties(F.phrase_boundary(nucleusIndexes), 'no_phrase_bnd');
    
    % phrase type
  elseif strcmp(property, 'terminal_phrase') ==1
    t = phone_has_properties(F.phrase_type(nucleusIndexes), 'terminal_phrase');
  elseif strcmp(property, 'progredient_phrase') ==1
    t = phone_has_properties(F.phrase_type(nucleusIndexes), 'progredient_phrase');
    
   % phrase length in syllables
  elseif strcmp(property, 'phrase_length_1') ==1
      t = F.phrase_size(nucleusIndexes) == 1;
  elseif strcmp(property, 'phrase_length_2') ==1
      t = F.phrase_size(nucleusIndexes) == 2;
  elseif strcmp(property, 'phrase_length_3-4') == 1
      t = F.phrase_size(nucleusIndexes) == 4 | F.phrase_size(nucleusIndexes) == 4;
  elseif strcmp(property, 'phrase_length_5-7') ==1
      t = F.phrase_size(nucleusIndexes) >= 5 & F.phrase_size(nucleusIndexes) <= 7;
  elseif strcmp(property, 'phrase_length_other') ==1
      t = F.phrase_size(nucleusIndexes) >= 8;
  else
     error(['*** Invalid syllable property:  <' char(property) '>!']);
  end

  
  
  
  
  
  
  
  
  
  
  

