function [sig, SamplFreq] =  signal_generation (elems, el_durs, el_freqs);
%
%  [sig, SamplFreq] =  signal_generation (elems, el_durs, el_freqs)
%  
%  Production of a speech signal from half diphones using
%  LPC-analysis-synthesis.
%
%  Input:
%
%   elems    - array of half diphone elements to use
%   el_durs  - duration of each element
%   el_freqs - fundamental frequency of each element
%
%  Output:
%
%   sig        - speech signal (normalized to 1)
%   SampleFreq - sampling frequency used for signal
  
% -----------------------------------------------------------------------

%   LPC-Analyse/Synthese-Parameter
%-------------------------------------
%
SamplFreq = 8000;  % Hz
POrd = 12;         % Praediktorordnung
WinSize = 176;     % Laenge des Analysefensters
WinShift = 80;     % Verschiebung des Analysefensters


%   Verkettungssynthese
%------------------------------------
%
sig = diphone_synthesis(elems,el_durs,el_freqs,SamplFreq,POrd, ...
                          WinSize,WinShift);
sig = sig./max(sig)*0.99;


%   Anzeigen des Signals
%--------------------------------------------------
%
t = [1:length(sig)]/SamplFreq;
plot(t,sig);
xlim = [0 max(t)];
ylim = [1.1*min(sig) 1.1*max(sig)];
set(gca,'xlim',xlim)
set(gca,'ylim',ylim)
