function tree = rhythmicstressshift (tree, nodeid, shiftpatlst);

% tree = rhythmicstressshift (tree, nodeid, shiftpatlst);
% 
% Applys stress shift patterns defined in 'shiftpatlst' onto the
% subtree of syntax tree 'tree' that starts at node 'nodeid'.
  
% find the nodes that belong to the subtree and that
% have a accentuation between 1 and 3
strshiftnodes = [];
j = 1;
for i=1:length(tree),
  if any(ismember(nodeid, tree(i).path)) && ...
		  ~isempty(tree(i).acc) && (tree(i).acc>0) && (tree(i).acc<4)
	  strshiftnodes(j) = i;
	  j = j+1;
  end
end

% now walk the nodes from left to right and apply the patterns
ind = 1;
while (ind<length(strshiftnodes)-1),
  for s=1:length(shiftpatlst),
	 if tree(strshiftnodes(ind)).acc==shiftpatlst(s).old(1) & ...
			 tree(strshiftnodes(ind+1)).acc==shiftpatlst(s).old(2) & ...
			 tree(strshiftnodes(ind+2)).acc==shiftpatlst(s).old(3),
		tree(strshiftnodes(ind)).acc = shiftpatlst(s).new(1);
		tree(strshiftnodes(ind+1)).acc = shiftpatlst(s).new(2);
		tree(strshiftnodes(ind+2)).acc = shiftpatlst(s).new(3);
	 end
  end
  ind = ind+1; 
end

