function [tree] = read_syntphol (text);
  
%  [tree] = read_syntphol (text);
% 
%  Read syntactic-phonological description from string 'input' into
%  'tree'.
%
%  inputs:  text     string containing syntactic-phonological 
%                    description.
%
%  outputs: tree     annotated syntactic tree.  
%
%                    tree.id     identifier of tree node
%                    tree.path   path from root node (list of tree ids) 
%                    tree.name   name of constituent  
%                    tree.level  tree level (root level = 0)
%                    tree.term   is terminal node? 
%                    tree.graph  graphemic string of word constituent
%                    tree.phon   phonetic string of word constituent
%                    tree.sylnr  number of syllables
%                    tree.accnr  number of accented syllables
%                    tree.acc    main stress of word constituent

punctcons = 'PUNCT';  % constituent for punctuations

cons_st = findstr(text,'(');
consdesc_end = findstr(text,';');
cons_end = findstr(text,')');
if (length(cons_st) ~= length(consdesc_end)) | ...
   (length(cons_st) ~= length(cons_end))
  error(['*** unbalanced tree structure in syntactic-phonological' ...
			 ' description!']);
end

phon_st = findstr(text,'[');
phon_end = findstr(text,']');
if length(phon_st) ~= length(phon_end)
 error(['*** unbalanced phonetic structure in ' ...
			 'syntactic-phonological description!']);
else
 t = zeros(1,size(phon_end,2)+1);
 t(2:end) = phon_end;
 if ~isempty(find(t(1:end-1)>phon_st)),
   error(['*** overlapping phonetic structure in ' ...
          'syntactic-phonological description!\n']);
 end
end
 
graph_st = find(text == '{');
graph_end = find(text == '}');
if any(size(graph_st) ~= size(graph_end)),
  fprintf(['*** unbalanced graphemic structure in ' ...
           'syntactic-phonological description!\n']);
else
  t = zeros(1,size(graph_end,2)+1);
  t(2:end) = graph_end;
  if ~isempty(find(t(1:end-1)>graph_st)),
    fprintf(['*** overlapping graphemic structure in ' ...
	     'syntactic-phonological description!\n']);
 end
end

desc = [cons_st+1;consdesc_end-1]';
phon = [phon_st+1;phon_end-1]';
graph = [graph_st+1;graph_end-1]';

level = zeros(1,size(cons_st,2));
ind = 1;
level(ind) = 0;
j = 1;
phind = 1;
grind = 1;
nodeind = 1;
nrnodes = size(cons_st,2);
i = 1;
while (nodeind <= nrnodes),
 
  while (cons_end(j) < cons_st(i)),
    node(nodeind-1).term = 1;
    level(ind) = 0;
    ind = ind - 1;
    j = j + 1;
  end
  node(nodeind).id = nodeind;
  node(nodeind).path = [level(2:ind) nodeind];
 
  ind = ind + 1;
  level(ind) = nodeind;
 
                            % symbol codes of constituent names
  node(nodeind).name = text(desc(i,1):desc(i,2));
 
                            % tree level (root == 0) 
  node(nodeind).level = ind-2;
  node(nodeind).term = 0;
 
                            % graphemic string of constituents
  if (grind<=length(graph_st) & (graph_st(grind) > cons_st(i)) & ... 
     ((nodeind == nrnodes) | (graph_end(grind) < cons_st(i+1)))), 
    node(nodeind).graph = text(graph(grind,1):graph(grind,2));
%    fprintf('%s ',text(desc(i,1):desc(i,2)));
%    fprintf('{%s}\n',text(graph(grind,1):graph(grind,2)));
    grind = grind + 1;
  end
 
                            % phonetic string of constituents
  if (phind<=length(phon_st) & (phon_st(phind) > cons_st(i)) & ... 
     ((nodeind == nrnodes) | (phon_end(phind) < cons_st(i+1)))), 
                            % no syllables for punctuation constituents
    if ~strcmp(node(nodeind).name,punctcons),
      phonstr = text(phon(phind,1):phon(phind,2));
      node(nodeind).phon = text(phon(phind,1):phon(phind,2));
      sylind = findstr(phonstr,'-');
                            % nr of syllables
      node(nodeind).sylnr = length(sylind)+1;
      node(nodeind).accnr = length(findstr(phonstr,char(39))) + ...
                            length(findstr(phonstr,','));
      if ~isempty(length(findstr(phonstr,char(39)))),
        node(nodeind).acc = 1;
      elseif ~isempty(length(findstr(phonstr,','))),
        node(nodeind).acc = 0;
      else
        node(nodeind).acc = 0;
      end
    end
    phind = phind+1;
  end
%  fprintf('node %s\n',text(desc(i,1):desc(i,2)));
%  fprintf('index: '); fprintf('%d ', ind);  fprintf('\n');
%  fprintf('level: '); fprintf('%d ',level); fprintf('\n');
%  fprintf('nodes: '); fprintf('%d ',nodes); fprintf('\n');
  i = i+1;
  nodeind = nodeind+1;
end
node(nodeind-1).term = 1;

tree = node;
