function  [c,res] = parse_text(gramfile,itext)
%
%  function  [c,res] = parse_text(gramfile,itext)
%
%  This Matlab function is a wrapper for the Java DCG parser to 
%  make it platform-indedendent. 
%
%  Inputs:    gramfile  file with the DCG grammar 
%             itext     input text to be analyzed 
%
%  Outputs:   c         completion code (0 means success)
%             res       parser output (syntax tree etc.)

if exist(gramfile)
  grfile = which(gramfile);
else
  error(['*** file not found:  ' gramfile])
end

parsernam = 'dcg_parser.jar';

if exist(parsernam,'file')
  jarfile = which(parsernam);
  [pdir,fnam,ext] = fileparts(jarfile);
else
  pdir = 'Gegebenes/parser';
  jarfile = [pdir '/' parsernam];
  if ~exist(jarfile,'file')
    pdir = 'parser';
    jarfile = [pdir '/' parsernam];
    if ~exist(jarfile,'file')
      error(['*** parser not found:  '  parsernam char(10) ...
             '    Please add parser directory to Matlab path!'])
    end
  end
end

required_files = {'parser.dat','mophon.aut','antlr-runtime-3.1.jar'};
for i = 1:length(required_files)
  if ~exist([pdir '/' required_files{i}])
    error(['*** file not found:  ' required_files{i} char(10) ...
           '    Please put it into directory  ' pdir])
  end
end

autfile = [pdir '/mophon.aut'];

cmd = ['java -jar ' jarfile ' -s -p ' autfile ' ' grfile];
[c,res] = system([cmd ' "' itext '"']);

if nargout == 0
  res
end
