function [ph,s] = nextphone (s)
%  
% [ph,s] = nextphone(s);
%
% Return first phone id in phone sequence 's' and rest of phone sequence.
  
phs = { '2' '2:' '6' '9' '9:' '@' 'E' 'E:' 'I' 'O' 'O_y' 'U' 'Y' ...
		  'a' 'a:' 'a_i' 'a_u' 'e' 'e:' 'i'  'i:' 'o' 'o:' 'u' 'u:' ...
		  'y' 'y:' ...
		  '>' '?' 'C' 'N' 'S' 'b' 'd' 'f' 'g' 'h' 'j' 'k' 'l' 'm' ...
		  'n' 'p' 'r' 's' 't' 'v' 'x' 'z' 't_s' };

% replacement structure
% any of the phones in old are replaced by the ones in new
% so phones that are not contained in the prosody corpus (training data)
% can be replaced by ones contained
% Addition by TE, 4/2008 
replacementItems_old{1} = 't_s';
replacementItems_new{1} = {'t', 's'};
replacementItems_old{2} = 'p_f';
replacementItems_new{2} = {'p', 'f'};


if isempty(s)
  ph = [];
  return
end

% remove blanks      
s = regexprep(s,'[ \n\c\r]','');
      
if isempty(s)
  ph = [];
  return
end

% convert to cell array
phsize=zeros(length(phs),1);
for i = 1:length(phs)
  phsize(i) = length(phs{i});
end

% calc. max. phone size
slen = length(s);
maxphsize = max(phsize);
if slen < maxphsize
  maxphsize = slen;
end

% match longest phones first 
ph = [];
for len = maxphsize:-1:1,
  phind = find(phsize == len);
  res = strfind(phs(phind),s(1:len));
  r = zeros(length(res),1);
  for i = 1:length(res)
	 r(i) = ~isempty(res{i});
  end
  if sum(r) > 0
	 if sum(r) > 1
		errmsg = sprintf(['Two or more identical phones <%s> in phone' ...
								' database'],s(1:len));
		error(errmsg);
	 end
	 ph = char(phs(phind(r>0)));
     s = s(len+1:end);
     
    % Addition by TE, 4/2008 
    i = strmatch(ph, replacementItems_old, 'exact');
    if ~isempty(i)
        ph = replacementItems_new{i}{1};
        if length(replacementItems_new{i}) > 1
            s = strcat(replacementItems_new{i}{2:end}, s);
        end
    end     
     
     
	 return;
  end
end



