function  [C,desc] = get_dur_rule_conditions_sol(F)
%
%  function:  [C,desc] = get_dur_rule_conditions_sol(F);
%
%  Determine the matrix `C` of rule conditions for a sequence of 
%  phones given by vector `F.phone_id`. 
%  The further fields in structure `F` contain information of the 
%  phone and its position (see: help load_training_data)
%
%  Note:  This is a reasonably good solution

C = ones(size(F.phone_id, 1), 1);
desc{1} = {'mittlere Lautdauer'};

C(:,end+1) = phone_has_properties(F,'long_vowel');
desc{end+1} = {'Langvokal'};

C(:,end+1) = phone_has_properties(F,'diphthong');
desc{end+1} = {'Diphthong'};

C(:,end+1) = phone_has_properties(F,'accent_1');
desc{end+1} = {'Akzent 1'};

C(:,end+1) = phone_has_properties(F,'accent_0');
desc{end+1} = {'Akzent 0'};

C(:,end+1) = phone_has_properties(F,'phrase_bnd_0');
desc{end+1} = {'Phrasengrenze 0 (Satzgrenze)'};

C(:,end+1) = phone_has_properties(F,'phrase_bnd_1');
desc{end+1} = {'Phrasengrenze 1'};

C(:,end+1) = phone_has_properties(F,'no_phrase_bnd');
desc{end+1} = {'keine Phrasengrenze'};

C(:,end+1) = phone_has_properties(F,'plosive');
desc{end+1} = {'Plosiv'};

C(:,end+1) = phone_has_properties(F,'fricative');
desc{end+1} = {'Frikativ'};

C(:,end+1) = phone_has_properties(F,'schwa');
desc{end+1} = {'Schwa'};

C(:,end+1) = phone_has_properties(F,'preplosive_pause');
desc{end+1} = {'praeplosive Pause'};

C(:,end+1) = phone_has_properties(F,'previous_phone_is_short_vowel');
desc{end+1} = {'Vorgaengerlaut ist Kurzvokal'};

C(:,end+1) = phone_has_properties(F,'syllable_size_1');
desc{end+1} = {'Silbengroesse 1'};

C(:,end+1) = phone_has_properties(F,'syllable_size_2');
desc{end+1} = {'Silbengroesse 2'};

C(:,end+1) = phone_has_properties(F,'syllable_size_3');
desc{end+1} = {'Silbengroesse 3'};

C(:,end+1) = phone_has_properties(F,'syllable_size_4');
desc{end+1} = {'Silbengroesse 4'};

C(:,end+1) = phone_has_properties(F,'syllable_size_5');
desc{end+1} = {'Silbengroesse 5'};

C(:,end+1) = phone_has_properties(F,'syllable_size_6');
desc{end+1} = {'Silbengroesse 6'};

C(:,end+1) = phone_has_properties(F,'syllable_size_7');
desc{end+1} = {'Silbengroesse 7'};

C(:,end+1) = phone_has_properties(F,'nucleus');
desc{end+1} = {'Nukleus'};

C(:,end+1) = phone_has_properties(F,'nasal');
desc{end+1} = {'Nasal'};

C(:,end+1) = phone_has_properties(F,'phone_is_before_preplosive_pause');
desc{end+1} = {'Laut vor praeplosiver Pause'};

C(:,end+1) = phone_has_properties(F,'jlr');
desc{end+1} = {'Laut [j], [l] oder [r]'};

