function [C,desc] = get_F0_rule_conditions_sol(F);
%
%  [C,desc] = get_F0_rule_conditions(F);
%
%  Calculate fundamental frequency rule conditions 'C' of sentences 
%  given as phonological structure 'F'. The output argument 'desc' 
%  contains a description of each rule condition.
%  
%  Elements of 'F':   F.sentence_number
%                     F.syllable_number
%                     F.syllable_size 
%                     F.phone_number 
%                     F.phone_position 
%                     F.phone_id 
%                     F.accent
%                     F.phrase_type 
%                     F.phrase_boundary
%                     F.phrase_size
% 

%  Note: this function is referenced by exercise 18


%===== mittlere Grundfrequenz =====

                                   % find indices of all syllable nuclei
nucleusIndexes = find(phone_has_properties(F,'nucleus')); 
C = ones(size(nucleusIndexes,1),1);
desc{1} = ['mittlere Grundfrequenz'];


%===== Position der Silbe in der Phrase =====

                                % compute relative position of syll:  (j-1)/J
nuc_syllable_number = F.syllable_number(nucleusIndexes);  % = j
nuc_syllable_length = F.phrase_size(nucleusIndexes);      % = J
rel_syllable_position = (nuc_syllable_number-1) ./ nuc_syllable_length;

%----- j-th syllable in progredient phrase -----
progredient_phrase_true = syllable_has_properties(F,'progredient_phrase');
C = [C rel_syllable_position .* progredient_phrase_true];
desc{end+1} = 'j-te Silbe in progredienter Phrase';

%----- j-th syllable in terminal phrase -----
terminal_phrase_true = syllable_has_properties(F,'terminal_phrase');  
C = [C rel_syllable_position .* terminal_phrase_true];
desc{end+1} = 'j-te Silbe in terminaler Phrase';

%----- last syllable in phrase -----
C = [C syllable_has_properties(F,'phrase_bnd_0')];
desc{end+1} = 'letzte Silbe in Terminalphrase';
C = [C syllable_has_properties(F,'phrase_bnd_1')];
desc{end+1} = 'letzte Silbe in progredienter Phrase';
C = [C syllable_has_properties(F,'phrase_bnd_2')];
desc{end+1} = 'letzte Silbe vor Phrasengrenze #{2}';


%===== Phrasentyp ===== 

C = [C syllable_has_properties(F,'progredient_phrase')];    
desc{end+1} = 'Silbe in progredienter Phrase';
C = [C syllable_has_properties(F,'terminal_phrase')];    
desc{end+1} = 'Silbe in Terminalphrase';


%===== Staerke des Silbenakzents =====

C = [C syllable_has_properties(F, 'accent_1')];
desc{end+1} = 'Akzent 1';
C = [C syllable_has_properties(F, 'accent_2')];
desc{end+1} = 'Akzent 2';
C = [C syllable_has_properties(F, 'accent_3')];
desc{end+1} = 'Akzent 3';
C = [C syllable_has_properties(F, 'accent_0')];
desc{end+1} = 'kein Akzent';
   

%===== Lautliche Eigenschaften der Silbe ======

C = [C syllable_has_properties(F,'nucleus_open_vowel') ]; 
desc{end+1} = 'Silbenkern offener Vokal';
C = [C syllable_has_properties(F,'nucleus_close_vowel')]; 
desc{end+1} = 'Silbenkern geschlossener Vokal';
C = [C syllable_has_properties(F,'nucleus_front_vowel')];
desc{end+1} = 'Silbenkern vorne artikulierter Vokal';
C = [C syllable_has_properties(F,'nucleus_short_vowel')];
desc{end+1} = 'Silbenkern Kurzvokal';
C = [C syllable_has_properties(F,'nucleus_long_vowel')];
desc{end+1} = 'Silbenkern Langvokal';
C = [C syllable_has_properties(F,'nucleus_schwa')];
desc{end+1} = 'Silbenkern Schwa';
C = [C syllable_has_properties(F,'onset_is_voiced')];
desc{end+1} = 'Silbenansatz stimmhaft';
C = [C syllable_has_properties(F,'coda_is_voiced')];
desc{end+1} = 'Silbenkoda stimmhaft';


