function disptree(tree, format);
  
% disptree (tree, format)
%  
% Displays data of syntactic tree 'tree'.
%
% Input:
%   tree   syntactic tree to show
%   format output format, one of
%           'text'     display tree as a list of nodes
%           'graph'    display tree graphically 
%                      in the current figure (default)
%           'sentence' display the graphemic representation
  
if (nargin > 1) && strcmp(format, 'text')
  for i = 1:length(tree),
    fprintf('[%2d] %s', tree(i).id, tree(i).name);
    if ~isempty(tree(i).graph),
      fprintf('   {%s} [%s]',tree(i).graph,tree(i).phon); 
    end
    fprintf('\n'); 
    fprintf('     term: %d level: %d path: ', tree(i).term, tree(i).level);
    fprintf('%d ',tree(i).path);
    fprintf('\n'); 
    if ~isempty(tree(i).sylnr),
      fprintf('     sylnr: %d accnr: %d acc: %d', ...
               tree(i).sylnr, tree(i).accnr, tree(i).acc);
      fprintf('\n'); 
    end
    fprintf('\n'); 
  end
elseif (nargin > 1) && strcmp(format, 'sentence')
  for i=1:length(tree),
    if ~isempty(tree(i).graph)
      fprintf('%s', [regexprep(tree(i).graph, '[+$#]', '') ' ']);
    end
  end
  fprintf('\n');
else
  treedesc = {tree.graph}';
	% remove syllable boundaries, word endings, and empty suffixes
  for i = 1:size(treedesc,1),
    if ~isempty(treedesc{i}),
      treedesc{i} = regexprep(treedesc{i},'[-#$]','');
    end
  end
  plottree(tree,treedesc,{tree.name}');
end
