function tree = accentnormalization (tree, phrbnd);
  
% tree = accentnormalization (tree, phrbnd);
%
% Normalize the accents. For each phrase the main accent becomes 1,
% the other accents are normalized to accents 2 - 4. Unaccented
% words get accent 0.
  
if (length([tree.sylnr]) ~= (length(phrbnd)-1)),
  error('*** Unbalanced word cons (%d) and phrase boundaries (%d)\n', ...
			 length([tree.sylnr]), length(phrbnd));
  return
end

% indices of phrase boundries
pbind = find(phrbnd >= 0 );
% indices of terminal nodes
wcons = find([tree.term]==1);

for i=1:length(pbind)-1,
	% accents of words in the phrase (setting unaccentated words to infinity]
  wacc = [tree(wcons(pbind(i):pbind(i+1)-1)).acc];
  wacc(wacc == -1) = Inf;
  maskacc = ones(1,pbind(i+1)-pbind(i));
  
  % find phrase main accent
	[minacc, minpos] = min(wacc);
	if minacc < Inf
		maskacc(minpos) = Inf;
		wacc(minpos) = 1;
	end
  
  % normalize other accents
  minacc = min(wacc.*maskacc);
  if minacc<Inf,
	 maskacc(wacc==minacc) = Inf;
	 wacc(wacc==minacc) = 2;
  end
	 
  minacc = min(wacc.*maskacc);
  if minacc<Inf,
	 maskacc(wacc==minacc) = Inf;
	 wacc(wacc==minacc) = 3;
  end
  
  wacc(maskacc==1 & wacc<Inf) = 4;
  wacc(wacc==Inf) = 0;

	% write the accents back into the table
  for j=1:length(wacc)
	 tree(wcons(j+pbind(i)-1)).acc = wacc(j);
  end
end
