/*
 * Decompiled with CFR 0.152.
 */
package speeth.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import speeth.util.CharTreeNavigator;

public class CharTree<T> {
    protected String mKey = null;
    protected Map<Character, CharTree<T>> mChildren = null;
    protected List<T> mContent = null;

    public CharTree() {
        this.mChildren = new HashMap<Character, CharTree<T>>();
    }

    private CharTree(String key, List<T> content, Map<Character, CharTree<T>> children) {
        this.mKey = key;
        this.mContent = content;
        this.mChildren = children;
    }

    protected boolean addContent(T value) {
        boolean ret = false;
        if (this.mContent == null) {
            ret = true;
            this.mContent = new ArrayList<T>();
        }
        this.mContent.add(value);
        return ret;
    }

    List<T> getContent() {
        return this.mContent;
    }

    String getKey() {
        return this.mKey;
    }

    CharTree<T> getChild(Character c) {
        return this.mChildren.get(c);
    }

    protected CharTree<T> getChildCreate(Character c) {
        CharTree<T> subkey = this.mChildren.get(c);
        if (subkey == null) {
            subkey = new CharTree<T>();
            this.mChildren.put(c, subkey);
        }
        return subkey;
    }

    public boolean add(String key, T value) {
        if (this.mKey == null) {
            this.mKey = new String(key);
            return this.addContent(value);
        }
        CharTree<T> subkey = null;
        int pos = 0;
        int maxlen = this.mKey.length() < key.length() ? this.mKey.length() : key.length();
        while (pos < maxlen && this.mKey.charAt(pos) == key.charAt(pos)) {
            ++pos;
        }
        if (pos < this.mKey.length()) {
            subkey = new CharTree<T>(this.mKey.substring(pos), this.mContent, this.mChildren);
            this.mContent = null;
            this.mChildren = new HashMap<Character, CharTree<T>>();
            this.mChildren.put(Character.valueOf(this.mKey.charAt(pos)), subkey);
            this.mKey = this.mKey.substring(0, pos);
        }
        if (pos < key.length()) {
            subkey = this.getChildCreate(Character.valueOf(key.charAt(pos)));
            if (subkey == null) {
                return false;
            }
        } else {
            return this.addContent(value);
        }
        return subkey.add(key.substring(pos), value);
    }

    public CharTreeNavigator<T> navigate() {
        return new CharTreeNavigator(this);
    }

    public String toString() {
        String s = "";
        if (this.mContent != null) {
            for (Object object : this.mContent) {
                s = String.valueOf(s) + "\n" + object.toString();
            }
        }
        for (CharTree charTree : this.mChildren.values()) {
            s = String.valueOf(s) + charTree.toString();
        }
        return s;
    }

    public String toTreeString() {
        String s = "+- ";
        if (this.mKey != null) {
            s = String.valueOf(s) + this.mKey;
        }
        s = String.valueOf(s) + "  [";
        if (this.mContent != null && this.mContent.size() > 0) {
            for (T t : this.mContent) {
                s = String.valueOf(s) + "(" + t.toString() + ")";
            }
        }
        s = String.valueOf(s) + "]";
        if (this.mChildren != null && this.mChildren.size() > 0) {
            String prev = "|";
            for (CharTree<T> t : this.mChildren.values()) {
                s = String.valueOf(s) + "\n   " + prev.replaceAll("\n", "\n   |");
                prev = t.toTreeString();
            }
            s = String.valueOf(s) + "\n   " + prev.replaceAll("\n", "\n    ");
        }
        return s;
    }
}

