/*
 * Decompiled with CFR 0.152.
 */
package speeth.output.cmdtool;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import speeth.input.grammarfile.VoxGrammarLexer;
import speeth.input.grammarfile.VoxGrammarParser;
import speeth.lang.AnalysisException;
import speeth.lang.EncodingException;
import speeth.lang.GrammarFileException;
import speeth.lang.LangDB;
import speeth.lang.TLRAutomat;
import speeth.output.SynTreeFormat;
import speeth.parser.SentenceAnalyser;
import speeth.parser.SynTree;
import speeth.parser.WordAnalyser;

public class Parse {
    static String mGramFile;
    static LangDB mGramDescr;
    static String mInput;
    static SentenceAnalyser mSAnalyser;
    static WordAnalyser mWAnalyser;
    static boolean mQuiet;
    static boolean mShowBracket;
    static String mOutFile;
    static String mStartCons;
    static String mPhonTrans;

    static {
        mQuiet = false;
        mShowBracket = false;
        mOutFile = null;
        mStartCons = null;
        mPhonTrans = null;
    }

    static void printUsage() {
        System.err.println("Syntax: parse-java [options] grammarfile \"inputstring\"\n");
        System.err.println("Parse \"inputstring\" using the grammar specified in <grammarfile>.\n");
        System.err.println("Optional parameters:");
        System.err.println("-o filename  Save first solution in tree in bracket notation in the file.");
        System.err.println("-c sym       Start parsing at symbol sym.");
        System.err.println("-p filename  Supply a phonetics transductor using the old format");
        System.err.println("-q           Quiet mode. Print nothing to standard output.");
        System.err.println("-s           Show first tree in bracket notation after processing, even in quiet mode\n");
    }

    static boolean readCmdLine(String[] args) {
        int pos = 0;
        int len = args.length;
        while (pos < len && args[pos].charAt(0) == '-') {
            switch (args[pos].charAt(1)) {
                case 'q': {
                    mQuiet = true;
                    break;
                }
                case 's': {
                    mShowBracket = true;
                    break;
                }
                case 'o': {
                    if (pos + 1 >= len || args[pos + 1].charAt(0) == '-') {
                        return false;
                    }
                    mOutFile = args[pos + 1];
                    ++pos;
                    break;
                }
                case 'c': {
                    if (pos + 1 >= len || args[pos + 1].charAt(0) == '-') {
                        return false;
                    }
                    mStartCons = args[pos + 1];
                    ++pos;
                    break;
                }
                case 'p': {
                    if (pos + 1 >= len || args[pos + 1].charAt(0) == '-') {
                        return false;
                    }
                    mPhonTrans = args[pos + 1];
                    ++pos;
                    break;
                }
                default: {
                    return false;
                }
            }
            ++pos;
        }
        if (pos + 2 > len) {
            return false;
        }
        mGramFile = args[pos];
        mInput = args[pos + 1];
        return true;
    }

    static void loadGrammarFromFile() throws IOException {
        ANTLRFileStream input = new ANTLRFileStream(mGramFile);
        VoxGrammarLexer lexer = new VoxGrammarLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        VoxGrammarParser parser = new VoxGrammarParser(tokens);
        try {
            mGramDescr = parser.file();
        }
        catch (RecognitionException e) {
            new RuntimeException("Parsing caused RecognitionException. That should not happen.", e);
        }
        Parse.loadExternalTransducer();
    }

    static void loadExternalTransducer() throws IOException {
        if (mPhonTrans != null) {
            VoxGrammarParser parser = new VoxGrammarParser(new CommonTokenStream(new VoxGrammarLexer(new ANTLRFileStream(mPhonTrans))));
            LangDB gram = new LangDB(true, false);
            try {
                parser.fileOld(gram);
            }
            catch (RecognitionException e) {
                throw new RuntimeException("Parsing of transducer caused RecognitionException. That should not happen.", e);
            }
            catch (GrammarFileException e) {
                System.err.println("Error parsing transducer:");
                throw e;
            }
            Collection<String> tlrs = gram.getTLRs();
            if (tlrs.size() > 1) {
                throw new GrammarFileException(-1, "Multiple TLRs found (" + tlrs + ") in transducer file " + mPhonTrans + ".");
            }
            if (tlrs.size() == 1) {
                TLRAutomat tlr = gram.getTLR(tlrs.iterator().next());
                tlr.setName("mophon");
                try {
                    tlr.setAlphabet(mGramDescr.getAlphabet("phon"), true);
                }
                catch (EncodingException e) {
                    System.err.println("Error in transducer file " + mPhonTrans + ":");
                    throw new GrammarFileException(-1, e.getMessage());
                }
                mGramDescr.addTLR(tlr);
            } else {
                System.err.println("Warning: no TLR found in the given transducer file. Using default one.");
            }
        }
    }

    static void parseAndPrint() throws GrammarFileException, AnalysisException {
        SentenceAnalyser sana = mGramDescr.createSentenceAnalyser();
        StringBuffer msg = new StringBuffer();
        boolean isok = sana.check(msg);
        System.err.println(msg);
        System.err.flush();
        if (!(isok &= mGramDescr.getTLR("mophon").check(msg))) {
            return;
        }
        Iterable<SynTree> result = sana.analyse(mStartCons, mInput);
        if (!result.iterator().hasNext()) {
            System.out.format("String <%s> not analysable.", mInput);
            System.exit(4);
        } else {
            StringBuffer str = new StringBuffer();
            StringBuffer phon = new StringBuffer();
            boolean hasPhon = false;
            try {
                Iterator<SynTree> it;
                if (!mQuiet) {
                    int i = 1;
                    for (SynTree s : result) {
                        SynTreeFormat f = new SynTreeFormat(s);
                        str.append("\n\n").append(i).append(". SOLUTION: (\n").append(f.asciiTree());
                        phon.append("\n\n").append(i).append(". SOLUTION:\n");
                        String p = f.phonStringTLR(mGramDescr.getTLR("mophon"));
                        if (p.length() > 0) {
                            phon.append(p);
                            hasPhon = true;
                        }
                        ++i;
                    }
                    System.out.print(str);
                    if (hasPhon) {
                        System.out.println("\n\n\nPhonetics:");
                        System.out.print(phon);
                    }
                }
                if (mShowBracket && (it = result.iterator()).hasNext()) {
                    System.out.println("\n\n\nTREE:");
                    SynTreeFormat f = new SynTreeFormat(it.next());
                    System.out.print(f.braceString(mGramDescr.getTLR("mophon"), true));
                    if (mOutFile != null) {
                        try {
                            FileWriter outfile = new FileWriter(new File(mOutFile));
                            outfile.write(f.braceString(mGramDescr.getTLR("mophon"), true));
                            outfile.close();
                        }
                        catch (IOException e) {
                            System.err.println("Error: cannot open file '" + mOutFile + "' for writing.");
                        }
                    }
                }
            }
            catch (EncodingException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void main(String[] args) {
        if (Parse.readCmdLine(args)) {
            block8: {
                try {
                    Parse.loadGrammarFromFile();
                    break block8;
                }
                catch (IOException e) {
                    System.err.print("Cannot open grammar file:\n");
                    System.err.println(e.getMessage());
                    System.exit(1);
                    break block8;
                }
                catch (GrammarFileException e) {
                    System.err.print("Error parsing grammar file:\n");
                    t /* !! */  = e;
                    ** while (t /* !! */ .getCause() != null)
                }
lbl-1000:
                // 1 sources

                {
                    t /* !! */  = t /* !! */ .getCause();
                    continue;
                }
lbl16:
                // 1 sources

                System.err.println(t /* !! */ .getMessage());
                System.exit(1);
            }
            try {
                System.err.println("*** Grammar loaded. Starting to analyse...");
                Parse.parseAndPrint();
                System.err.println("\n\nDone");
            }
            catch (Exception e) {
                System.err.println("Error parsing: " + e.getMessage());
                System.exit(2);
            }
        } else {
            Parse.printUsage();
            System.exit(-1);
        }
    }
}

