/*
 * Decompiled with CFR 0.152.
 */
package speeth.lang;

import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class TLRStateTable {
    Vector<int[]> mTrans = new Vector();
    int mNumClass;
    Vector<Integer> mLines = new Vector();

    public TLRStateTable(int numClass) {
        this.mNumClass = numClass;
    }

    public TLRStateTable(String content) {
        this.mNumClass = -1;
        String[] stringArray = content.split(" */ *");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] classes = s.split(" +");
            if (this.mNumClass == -1) {
                this.mNumClass = classes.length;
            } else if (this.mNumClass != classes.length) {
                throw new IllegalArgumentException("State table contains lines of different length.");
            }
            int[] field = new int[this.mNumClass];
            int i = 0;
            while (i < this.mNumClass) {
                field[i] = Integer.parseInt(classes[i]);
                ++i;
            }
            this.mTrans.add(field);
            ++n2;
        }
    }

    public void setField(int fromState, int fromClass, int toState) {
        if (this.mTrans.size() < fromState) {
            this.mTrans.setSize(fromState);
        }
        if (this.mTrans.get(fromState - 1) == null) {
            this.mTrans.set(fromState - 1, new int[this.mNumClass]);
        }
        this.mTrans.get((int)(fromState - 1))[fromClass - 1] = toState;
    }

    public int[] getLine(int state) {
        return this.mTrans.get(state - 1);
    }

    public Set<Integer> getOutStates(int state, Set<Integer> classes) {
        int[] line = this.getLine(state);
        HashSet<Integer> ret = new HashSet<Integer>();
        for (int i : classes) {
            ret.add(line[i - 1]);
        }
        return ret;
    }

    public int getNumStates() {
        return this.mTrans.size();
    }

    public boolean check(StringBuffer msg) {
        int maxTrans = this.mTrans.size();
        boolean ret = true;
        int l = 0;
        while (l < this.mTrans.size()) {
            int[] nArray = this.mTrans.get(l);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                if (i < 0 || i > maxTrans) {
                    msg.append(String.format("Error: line %d: Transition table references state %d which is not in the table.\n", this.mLines.get(l), i));
                    ret = false;
                }
                ++n2;
            }
            ++l;
        }
        return ret;
    }

    public void setSourceLine(int line, int code) {
        if (line >= this.mLines.size()) {
            this.mLines.setSize(line + 1);
        }
        this.mLines.set(line, code);
    }
}

