/*
 * Decompiled with CFR 0.152.
 */
package speeth.lang;

import java.util.List;
import speeth.lang.Constituent;
import speeth.parser.TreeInfo;
import speeth.parser.TreeNode;

public class GrammarRule
implements TreeInfo {
    Constituent mHead;
    Constituent[] mBody;
    int mPenalty = 1;
    boolean mIsRecursive = false;

    public GrammarRule(Constituent cons, List<Constituent> tail, int penalty) {
        this.mHead = cons;
        this.mPenalty = penalty;
        this.mBody = tail.toArray(new Constituent[0]);
    }

    @Override
    public String getConsName() {
        return this.mHead.getName();
    }

    @Override
    public Constituent getCons() {
        return this.mHead;
    }

    public Constituent[] getBodyCons() {
        return this.mBody;
    }

    public int getLine() {
        return this.mHead.getLine();
    }

    public void markRecursive() {
        this.mIsRecursive = true;
    }

    public boolean isRecursive() {
        return this.mIsRecursive;
    }

    @Override
    public String getGraph() {
        return "";
    }

    @Override
    public String getPhon() {
        return "";
    }

    @Override
    public boolean isTree() {
        return false;
    }

    @Override
    public TreeNode getTree() {
        return null;
    }

    @Override
    public int getPenalty() {
        return this.mPenalty;
    }

    @Override
    public void setPenalty(int penalty) {
        this.mPenalty = penalty;
    }

    public String toString() {
        String s = String.valueOf(this.mHead.toString()) + " ==>";
        if (this.mBody != null) {
            Constituent[] constituentArray = this.mBody;
            int n = this.mBody.length;
            int n2 = 0;
            while (n2 < n) {
                Constituent c = constituentArray[n2];
                s = String.valueOf(s) + " " + c.toString();
                ++n2;
            }
        }
        return s;
    }
}

