%  This Matlab script is a wrapper for the GUI-extended Java DCG 
%  parser to make it platform-indedendent. 

parsernam = 'JParser.jar';

if exist(parsernam,'file')
  jarfile = which(parsernam);
  [pdir,fnam,ext] = fileparts(jarfile);
else
  pdir = 'Gegebenes/parser_with_gui';
  jarfile = [pdir '/' parsernam];
  if ~exist(jarfile,'file')
    pdir = 'parser_with_gui';
    jarfile = [pdir '/' parsernam];
    if ~exist(jarfile,'file')
      error(['*** parser not found:  '  parsernam char(10) ...
             '    Please add parser directory to Matlab path!'])
    end
  end
end

required_files = {'antlr-runtime-3.1.jar'};
for i = 1:length(required_files)
  if ~exist([pdir '/' required_files{i}])
    error(['*** file not found:  ' required_files{i} char(10) ...
           '    Please put it into directory  ' pdir])
  end
end

autfile = [pdir '/mophon.aut'];

[c,res] = system(['java -jar ' jarfile]);

if c ~= 0
  disp('*** Java DCG parser with GUI cannot be stared')
  disp(['    ' res])
end

