/*
 * Decompiled with CFR 0.152.
 */
package speeth.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import speeth.lang.AnalysisException;
import speeth.lang.Constituent;
import speeth.lang.Grammar;
import speeth.lang.GrammarRule;
import speeth.lang.LexEntry;
import speeth.lang.Lexicon;
import speeth.lang.TLRAutomat;
import speeth.parser.ChartParser;
import speeth.parser.TreeInfo;
import speeth.util.Tuple;

public class WordAnalyser {
    Grammar mGrammar;
    Lexicon mMorphLex;
    Lexicon mFullLex;
    TLRAutomat mGraphTLR;

    public WordAnalyser(Grammar wgram, Lexicon flex, Lexicon mlex, TLRAutomat tlr) {
        this.mGrammar = wgram;
        this.mFullLex = flex;
        this.mMorphLex = mlex;
        this.mGraphTLR = tlr;
    }

    public List<TreeInfo> analyse(String word) throws AnalysisException {
        return this.analyse(null, word);
    }

    public List<TreeInfo> analyse(String cons, String word) throws AnalysisException {
        if (word.length() == 0) {
            throw new IllegalArgumentException();
        }
        ArrayList<TreeInfo> ret = new ArrayList<TreeInfo>();
        if (this.mFullLex != null) {
            Iterator<Tuple<Integer, LexEntry>> it = this.mFullLex.iterateLookupTLR(word, this.mGraphTLR, true);
            while (it.hasNext()) {
                ret.add(it.next().getSecond());
            }
        }
        if (this.mMorphLex != null && this.mGrammar != null) {
            String mword = String.valueOf(word) + "#";
            int len = mword.length();
            ChartParser parser = new ChartParser(this.mGrammar, len + 1);
            boolean[] neededge = new boolean[len + 1];
            neededge[0] = true;
            int i = 1;
            while (i < len) {
                neededge[i] = false;
                ++i;
            }
            i = 0;
            while (i < len) {
                if (neededge[i]) {
                    Iterator<Tuple<Integer, LexEntry>> it = this.mMorphLex.iterateLookupTLR(mword.substring(i), this.mGraphTLR, false);
                    while (it.hasNext()) {
                        Tuple<Integer, LexEntry> t = it.next();
                        int tlen = t.getFirst();
                        neededge[i + tlen] = true;
                        parser.initEdge(i, tlen, t.getSecond());
                    }
                }
                ++i;
            }
            if (cons == null) {
                parser.parse(ret, null, true);
            } else {
                parser.parse(ret, cons, false);
            }
            if (ret.size() == 0) {
                throw new AnalysisException(String.format("Cannot analyse word '%s'.", word));
            }
        } else if (ret.size() == 0) {
            throw new AnalysisException(String.format("Word '%s' not found in lexicon.", word));
        }
        return ret;
    }

    public boolean check(StringBuffer msg) {
        boolean ret = true;
        if (this.mGrammar != null && this.mMorphLex != null) {
            HashSet<Constituent> lexentries = new HashSet<Constituent>();
            for (LexEntry e : this.mMorphLex) {
                lexentries.add(e.getCons());
            }
            ret = ret && this.mGrammar.check(lexentries, msg);
            for (GrammarRule r : this.mGrammar.getConsRules(this.mGrammar.getStartCons())) {
                if (r.getBodyCons().length == 1) continue;
                msg.append("Error: line ").append(r.getLine()).append('\n');
                msg.append("The root symbol of the word grammar must only point to rules for word forms.\n");
                msg.append("Therefore, the body of the rule must contain exactly one symbol.\n");
                ret = false;
            }
        }
        return ret &= this.mGraphTLR.check(msg);
    }

    public Set<Constituent> getRootSymbols() {
        HashSet<Constituent> ret = new HashSet<Constituent>();
        if (this.mGrammar != null) {
            for (GrammarRule r : this.mGrammar.getConsRules(this.mGrammar.getStartCons())) {
                if (r.getBodyCons().length != 1) continue;
                ret.add(r.getBodyCons()[0]);
            }
        }
        if (this.mFullLex != null) {
            for (LexEntry l : this.mFullLex) {
                ret.add(l.getCons());
            }
        }
        return ret;
    }
}

