/*
 * Decompiled with CFR 0.152.
 */
package speeth.parser;

import java.util.ArrayList;
import java.util.List;
import speeth.lang.Constituent;
import speeth.lang.VarList;
import speeth.parser.TreeInfo;
import speeth.parser.TreeNode;

public class SynTree
implements TreeInfo,
TreeNode {
    protected Constituent mCons;
    protected TreeInfo mInfo;
    protected VarList mSubst;
    protected int mPenalty = 0;
    protected List<SynTree> mChildren = new ArrayList<SynTree>();
    protected int pos = 0;
    protected int wordSpace = 30;

    public SynTree(Constituent cons, TreeInfo info, VarList subst) {
        this.mCons = cons;
        this.mInfo = info;
        this.mSubst = subst;
        this.mPenalty = info.getPenalty();
    }

    public SynTree(VarList subst) {
        this.mSubst = subst;
    }

    public void addLeaf(SynTree r) {
        this.mChildren.add(r);
        this.mPenalty += r.getPenalty();
    }

    public void copyLeafs(SynTree tree) {
        this.mChildren.addAll(tree.mChildren);
        for (SynTree t : tree.mChildren) {
            this.mPenalty += t.getPenalty();
        }
    }

    @Override
    public String getConsName() {
        return this.mCons.getName();
    }

    @Override
    public Constituent getCons() {
        return this.mCons;
    }

    public VarList getSubst() {
        return this.mSubst;
    }

    @Override
    public int getPenalty() {
        return this.mPenalty;
    }

    @Override
    public void setPenalty(int penalty) {
        this.mPenalty = penalty;
    }

    public boolean isCyclic() {
        SynTree subtree = this;
        while (subtree.mChildren.size() == 1) {
            subtree = subtree.mChildren.get(0);
            if (subtree.mInfo != this.mInfo) continue;
            return true;
        }
        return false;
    }

    public void setRule(TreeInfo rule) {
        assert (rule != null);
        if (this.mInfo != null) {
            this.mPenalty -= this.mInfo.getPenalty();
        }
        this.mInfo = rule;
        this.mCons = rule.getCons().copySubst(this.mSubst);
        this.mPenalty += rule.getPenalty();
    }

    @Override
    public SynTree getChild(int i) {
        return this.mChildren.get(i);
    }

    @Override
    public int getNumChildren() {
        return this.mChildren.size();
    }

    @Override
    public TreeInfo getNodeInfo() {
        return this.mInfo;
    }

    @Override
    public int findChild(TreeNode child) {
        return this.mChildren.indexOf(child);
    }

    @Override
    public String getGraph() {
        if (this.mChildren.size() == 0) {
            return this.mInfo.getGraph();
        }
        StringBuffer out = new StringBuffer();
        for (SynTree s : this.mChildren) {
            out.append(s.getGraph());
        }
        return out.toString();
    }

    @Override
    public String getPhon() {
        if (this.mChildren.size() == 0) {
            return this.mInfo.getPhon();
        }
        StringBuffer out = new StringBuffer();
        for (SynTree s : this.mChildren) {
            out.append(s.getPhon());
        }
        return out.toString();
    }

    @Override
    public boolean isTree() {
        return true;
    }

    @Override
    public TreeNode getTree() {
        return this;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("+- ");
        if (this.mChildren.size() > 0) {
            s.append(this.mCons);
            int i = 0;
            while (i < this.mChildren.size() - 1) {
                s.append("\n   |\n   ").append(this.mChildren.get(i).toString().replaceAll("\n", "\n   |"));
                ++i;
            }
            s.append("\n   |\n   ").append(this.mChildren.get(this.mChildren.size() - 1).toString().replaceAll("\n", "\n    "));
        } else {
            s.append(this.mInfo.toString());
        }
        return s.toString();
    }
}

