/*
 * Decompiled with CFR 0.152.
 */
package speeth.output.parsegui;

import java.awt.Color;
import java.awt.Graphics2D;
import speeth.lang.EncodingException;
import speeth.lang.TLRAutomat;
import speeth.output.SynTreeFormat;
import speeth.output.parsegui.LayoutNode;
import speeth.parser.SynTree;

public class LayoutTree {
    private int mWidth = 0;
    private int mHeight = 0;
    private LayoutNode mRoot;
    private String mPhoneString = "";

    public LayoutTree(SynTree syntree, TLRAutomat phon) {
        this.mRoot = new LayoutNode(syntree, this, phon.getAlphabet());
        SynTreeFormat f = new SynTreeFormat(syntree);
        try {
            this.mPhoneString = f.phonStringTLR(phon);
        }
        catch (EncodingException encodingException) {
            // empty catch block
        }
    }

    public void updateHeight(int ypos) {
        this.mHeight = Math.max(ypos, this.mHeight);
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void updateWidth(int xpos) {
        this.mWidth = Math.max(xpos, this.mWidth);
    }

    public void draw(Graphics2D g2, int width) {
        Color oldcolor = g2.getColor();
        g2.setColor(new Color(238, 204, 99));
        g2.fill3DRect(0, 0, width, 30, true);
        g2.setColor(Color.black);
        if (this.mPhoneString.isEmpty()) {
            g2.drawString("PARSE TREE:", 10, 20);
        } else {
            g2.drawString("PHONETIC TRANSCRIPTION:   " + this.mPhoneString, 10, 20);
        }
        g2.setColor(oldcolor);
        this.mRoot.draw(g2);
    }
}

