/*
 * Decompiled with CFR 0.152.
 */
package speeth.output.parsegui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import speeth.lang.Alphabet;
import speeth.lang.EncodingException;
import speeth.lang.Feature;
import speeth.output.parsegui.ConnectionNodeBox;
import speeth.output.parsegui.LayoutTree;
import speeth.output.parsegui.NodeBox;
import speeth.output.parsegui.StringNodeBox;
import speeth.parser.SynTree;
import speeth.parser.TreeInfo;
import speeth.parser.TreeNode;

public class LayoutNode {
    protected List<LayoutNode> mChildren = new ArrayList<LayoutNode>();
    private int mxPos;
    private int myPos;
    private LayoutNode mparent = null;
    private int mLevel;
    private NodeBox mNodeBox;
    private LayoutTree mLTreeInfo;
    private final int MIN_XDIST = 20;
    private final int Y_DIST = 50;
    private final int RIGHT_SHIFT = 10;
    private final int WORD_XFRAME = 10;
    private final int WORD_YFRAME = 5;
    private boolean mdebug = false;

    public LayoutNode(SynTree syntree, LayoutTree tree, Alphabet phon) {
        this.mLTreeInfo = tree;
        this.createTreeStruct(syntree, phon, 0);
        this.calcNodePositions();
    }

    private LayoutNode(LayoutNode parentTree) {
        if (parentTree != null) {
            parentTree.mChildren.add(this);
        }
        this.mparent = parentTree;
        this.mLTreeInfo = this.mparent.mLTreeInfo;
    }

    private void createTreeStruct(TreeNode synTree, Alphabet phon, int level) {
        this.mLevel = level + 1;
        TreeInfo ti = synTree.getNodeInfo();
        if (ti.isTree()) {
            this.mNodeBox = new ConnectionNodeBox(7.0f);
            LayoutNode newLayoutTree = new LayoutNode(this);
            newLayoutTree.createTreeStruct(ti.getTree(), phon, this.mLevel);
        } else {
            StringNodeBox nodebox = new StringNodeBox();
            nodebox.addString(synTree.getCons().getName(), Color.blue, 0.0f, 2);
            Feature f = synTree.getCons().getFeature();
            if (f != null) {
                StringBuffer fstr = new StringBuffer();
                this.featBraceString(fstr, f);
                nodebox.addString(fstr.toString(), new Color(0, 0, 80), -2.0f, 3);
            }
            nodebox.addString(synTree.getNodeInfo().getGraph(), Color.red, 0.0f, 10);
            int numchi = synTree.getNumChildren();
            String pstr = ti.getPhon();
            if (pstr != null && !pstr.isEmpty()) {
                try {
                    pstr = phon.decode(pstr);
                }
                catch (EncodingException e) {
                    pstr = "???";
                }
                nodebox.addString(String.valueOf('[') + pstr + ']', new Color(80, 0, 0), -1.0f, 3);
            }
            int ichild = 0;
            while (ichild < numchi) {
                LayoutNode newLayoutTree = new LayoutNode(this);
                newLayoutTree.createTreeStruct(synTree.getChild(ichild), phon, this.mLevel);
                ++ichild;
            }
            this.mNodeBox = nodebox;
        }
    }

    private void featBraceString(StringBuffer s, Feature f) {
        int n = f.getNumSubFeatures();
        if (n == 0) {
            s.append(f);
        } else {
            s.append('<');
            String delim = "";
            int i = 0;
            while (i < n) {
                s.append(delim);
                this.featBraceString(s, f.getSubFeature(i));
                delim = ",";
                ++i;
            }
            s.append('>');
        }
    }

    private void calcNodePositions() {
        int rightshift;
        this.mxPos = 0;
        this.myPos += this.mLevel * 50;
        int boxWidth = this.mNodeBox.getBoxWidth();
        int overlap = this.mxPos - boxWidth / 2 - this.mLTreeInfo.getWidth() - 20;
        if (overlap < 0) {
            this.mxPos = this.mLTreeInfo.getWidth() + 10 + boxWidth / 2;
            rightshift = 10;
        } else {
            rightshift = 0;
        }
        int numchi = this.mChildren.size();
        if (numchi != 0) {
            int ichild = 0;
            while (ichild < numchi) {
                this.mChildren.get(ichild).calcNodePositions();
                ++ichild;
            }
            int midDist = this.mChildren.get((int)(numchi - 1)).mxPos - this.mChildren.get((int)0).mxPos;
            this.mxPos = this.mChildren.get((int)0).mxPos + midDist / 2;
        }
        this.mNodeBox.updatexPos(this.mxPos);
        this.mNodeBox.updateyPos(this.myPos);
        this.mLTreeInfo.updateWidth(this.mxPos + rightshift + boxWidth / 2);
        this.mLTreeInfo.updateHeight(this.myPos + this.mNodeBox.getBoxHeight());
    }

    public void draw(Graphics2D g2) {
        this.mNodeBox.draw(g2);
        if (this.mparent != null) {
            this.drawLines(g2);
        }
        if (this.mdebug) {
            int bw = this.mNodeBox.getBoxWidth() / 2;
            int bh = this.mNodeBox.getBoxHeight() / 2;
            g2.drawLine(this.mxPos - bw, this.myPos - bh, this.mxPos - bw, this.myPos + bh);
            g2.drawLine(this.mxPos + bw, this.myPos - bh, this.mxPos + bw, this.myPos + bh);
            g2.drawLine(this.mxPos - bw, this.myPos - bh, this.mxPos + bw, this.myPos - bh);
            g2.drawLine(this.mxPos - bw, this.myPos + bh, this.mxPos + bw, this.myPos + bh);
        }
        for (LayoutNode lt : this.mChildren) {
            lt.draw(g2);
        }
    }

    private void drawLines(Graphics2D g2) {
        int pleftx = this.mparent.mxPos - this.mparent.mNodeBox.getBaseLineOffset() - 10;
        int prightx = this.mparent.mxPos + this.mparent.mNodeBox.getBaseLineOffset() + 10;
        int py = this.mparent.mNodeBox.getBaseLine();
        int ty = this.myPos;
        if (this.mxPos < pleftx) {
            g2.drawLine(this.mxPos, ty, this.mxPos, py);
            g2.drawLine(this.mxPos, py, pleftx, py);
        } else if (this.mxPos > prightx) {
            g2.drawLine(this.mxPos, ty, this.mxPos, py);
            g2.drawLine(this.mxPos, py, prightx, py);
        } else {
            g2.drawLine(this.mxPos, ty, this.mxPos, this.mparent.myPos + this.mparent.mNodeBox.getBoxHeight() + 5);
        }
    }
}

