/*
 * Decompiled with CFR 0.152.
 */
package speeth.lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import speeth.lang.Alphabet;
import speeth.lang.EncodingException;
import speeth.util.Tuple;

public class TLRClasses {
    int mDefClass;
    int mMaxClasses;
    Map<Character, TableLine> mTable = new HashMap<Character, TableLine>();

    public TLRClasses(int defclass) {
        this.mDefClass = defclass;
        this.mMaxClasses = defclass;
    }

    public void addTuple(Tuple<Character, Character> t, int classnr) {
        TableLine line = this.getInpList(t.getFirst());
        Tuple<Character, Integer> tuple = new Tuple<Character, Integer>(t.getSecond(), classnr);
        if (t.getFirst().compareTo(t.getSecond()) == 0) {
            if (t.getFirst().charValue() == '\u0000') {
                throw new IllegalArgumentException("The empty character cannot be mapped to itself.");
            }
            line.set(0, tuple);
        } else {
            line.add(tuple);
        }
        if (classnr > this.mMaxClasses) {
            this.mMaxClasses = classnr;
        }
    }

    private TableLine getInpList(Character c) {
        TableLine l = this.mTable.get(c);
        if (l == null) {
            l = new TableLine();
            if (c.charValue() != '\u0000') {
                l.add(new Tuple<Character, Integer>(c, this.mDefClass));
            }
            this.mTable.put(c, l);
        }
        return l;
    }

    public List<Tuple<Character, Integer>> get(char c) {
        return this.getInpList(Character.valueOf(c));
    }

    public TLRClasses getInverted() {
        TLRClasses inv = new TLRClasses(this.mDefClass);
        for (Map.Entry<Character, TableLine> line : this.mTable.entrySet()) {
            for (Tuple t : line.getValue()) {
                inv.addTuple(new Tuple<Character, Character>((Character)t.getFirst(), line.getKey()), (Integer)t.getSecond());
            }
        }
        return inv;
    }

    public void translate(Alphabet aFrom, Alphabet aTo) throws EncodingException {
        HashMap<Character, TableLine> newtab = new HashMap<Character, TableLine>();
        for (Map.Entry<Character, TableLine> line : this.mTable.entrySet()) {
            for (Tuple t : line.getValue()) {
                if (((Character)t.getFirst()).charValue() == '\u0000') continue;
                t.setFirst(Character.valueOf(aTo.encodeChar(aFrom.decodeChar(((Character)t.getFirst()).charValue()))));
            }
            char newkey = line.getKey().charValue() == '\u0000' ? (char)'\u0000' : aTo.encodeChar(aFrom.decodeChar(line.getKey().charValue()));
            newtab.put(Character.valueOf(newkey), line.getValue());
        }
        this.mTable.clear();
        this.mTable = newtab;
    }

    public int getMaxClasses() {
        return this.mMaxClasses;
    }

    class TableLine
    extends ArrayList<Tuple<Character, Integer>> {
        TableLine() {
        }
    }
}

