/*
 * Decompiled with CFR 0.152.
 */
package speeth.lang;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import speeth.lang.Alphabet;
import speeth.lang.EncodingException;
import speeth.lang.TLRClasses;
import speeth.lang.TLRStateTable;
import speeth.util.ComputingIterator;
import speeth.util.Tuple;

public class TLRAutomat {
    String mName;
    Alphabet mAlphabet;
    TLRClasses mClasses;
    TLRStateTable mTrans = null;
    private static TLRAutomat mDefGraphAutomat = null;
    private static TLRAutomat mDefPhonAutomat = null;

    public TLRAutomat(String name, Alphabet alph, TLRClasses classes, TLRStateTable states) {
        this.mName = name;
        this.mAlphabet = alph;
        this.mClasses = classes;
        this.mTrans = states;
    }

    public Alphabet getAlphabet() {
        return this.mAlphabet;
    }

    public void setAlphabet(Alphabet alph, boolean doTranslate) throws EncodingException {
        if (doTranslate) {
            this.mClasses.translate(this.mAlphabet, alph);
        }
        this.mAlphabet = alph;
    }

    public boolean isProductionRecursive() {
        List<Tuple<Character, Integer>> classes = this.mClasses.get('\u0000');
        if (classes.size() > 0) {
            HashSet<Integer> cint = new HashSet<Integer>();
            for (Tuple<Character, Integer> t : classes) {
                cint.add(t.getSecond());
            }
            int state = 1;
            while (state <= this.mTrans.getNumStates()) {
                HashSet tc = new HashSet();
                HashSet<Integer> newtc = new HashSet<Integer>();
                newtc.add(state);
                while (newtc.size() > tc.size()) {
                    tc = newtc;
                    newtc = new HashSet();
                    Iterator iterator = tc.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        newtc.addAll(this.mTrans.getOutStates(i, cint));
                    }
                    if (newtc.add(state)) continue;
                    return true;
                }
                ++state;
            }
        }
        return false;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public TLRAutomat getInverted() {
        return new TLRAutomat(String.valueOf(this.mName) + "Inv", this.mAlphabet, this.mClasses.getInverted(), this.mTrans);
    }

    public Iterator<Tuple<Character, Integer>> getCharTrans(Character c, Integer oldstate) {
        return new TLRTransIterator(this.mClasses.get(c.charValue()).listIterator(), this.mTrans.getLine(oldstate));
    }

    public boolean check(StringBuffer msg) {
        return this.mTrans.check(msg);
    }

    public static TLRAutomat getDefGraphAutomat() {
        if (mDefGraphAutomat == null) {
            try {
                TLRClasses cl = new TLRClasses(1);
                cl.addTuple(new Tuple<Character, Character>(Character.valueOf('+'), Character.valueOf('\u0000')), 1);
                cl.addTuple(new Tuple<Character, Character>(Character.valueOf('#'), Character.valueOf('\u0000')), 1);
                cl.addTuple(new Tuple<Character, Character>(Character.valueOf('$'), Character.valueOf('\u0000')), 1);
                mDefGraphAutomat = new TLRAutomat("mograph", Alphabet.getDefGraph(), cl, new TLRStateTable("1"));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't create default Graph TLR.", e);
            }
        }
        return mDefGraphAutomat;
    }

    public static TLRAutomat getDefPhonAutomat() {
        if (mDefPhonAutomat == null) {
            try {
                TLRClasses cl = new TLRClasses(1);
                cl.addTuple(new Tuple<Character, Character>(Character.valueOf('+'), Character.valueOf('\u0000')), 1);
                cl.addTuple(new Tuple<Character, Character>(Character.valueOf('#'), Character.valueOf('\u0000')), 1);
                mDefPhonAutomat = new TLRAutomat("mophon", Alphabet.getDefPhon(), cl, new TLRStateTable("1"));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't create default Phon TLR.", e);
            }
        }
        return mDefPhonAutomat;
    }

    private class TLRTransIterator
    extends ComputingIterator<Tuple<Character, Integer>> {
        ListIterator<Tuple<Character, Integer>> mChars;
        int[] mItTrans;

        TLRTransIterator(ListIterator<Tuple<Character, Integer>> chars, int[] trans) {
            this.mChars = chars;
            this.mItTrans = trans;
        }

        @Override
        public boolean computeNext() {
            while (this.mChars.hasNext()) {
                int ns;
                Tuple<Character, Integer> e = this.mChars.next();
                if (e.getSecond() <= 0 || (ns = this.mItTrans[e.getSecond() - 1]) <= 0) continue;
                this.mNext = new Tuple<Character, Integer>(e.getFirst(), ns);
                return true;
            }
            return false;
        }
    }
}

