/*
 * Decompiled with CFR 0.152.
 */
package speeth.lang;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import speeth.lang.GrammarFileException;
import speeth.lang.LexEntry;
import speeth.lang.TLRAutomat;
import speeth.util.CharTree;
import speeth.util.CharTreeNavigator;
import speeth.util.ComputingIterator;
import speeth.util.Tuple;

public class Lexicon
implements Iterable<LexEntry> {
    String mName;
    CharTree<LexEntry> mEntries = new CharTree();
    LexEntry mLast = null;
    boolean containsPhon = false;

    public Lexicon(String name, Collection<LexEntry> entries) throws GrammarFileException {
        this.mName = name;
        for (LexEntry e : entries) {
            this.add(e);
        }
    }

    protected void add(LexEntry entry) throws GrammarFileException {
        if (entry.hasPhon()) {
            this.containsPhon = true;
        } else if (this.containsPhon) {
            throw new GrammarFileException(entry.getLine(), "Phonemic description must be given either for all entries\nor for none of them. " + String.format("Lexicon entry <%s> misses phonemic description.", entry.getGraph()));
        }
        entry.setNextEntry(this.mLast);
        this.mLast = entry;
        this.mEntries.add(entry.getGraph(), entry);
    }

    @Override
    public Iterator<LexEntry> iterator() {
        return new LexEntryIt(this.mLast);
    }

    public Iterator<Tuple<Integer, LexEntry>> iterateLookupTLR(String lexstr, TLRAutomat tlr, boolean full) {
        return new LexItr(this.mEntries, lexstr, tlr, full);
    }

    public String getName() {
        return this.mName;
    }

    public String toString() {
        return "Lexikon \"" + this.mName + "\"\n" + this.mEntries.toString();
    }

    private class LexEntryIt
    implements Iterator<LexEntry> {
        LexEntry mCur;

        LexEntryIt(LexEntry first) {
            this.mCur = first;
        }

        @Override
        public boolean hasNext() {
            return this.mCur != null;
        }

        @Override
        public LexEntry next() {
            LexEntry ret = this.mCur;
            if (ret == null) {
                throw new NoSuchElementException();
            }
            this.mCur = ret.getNextEntry();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class LexItr
    extends ComputingIterator<Tuple<Integer, LexEntry>> {
        String mString;
        TLRAutomat mTLR;
        boolean mFull;
        Iterator<LexEntry> mCurIt = null;
        int mCurPos = 0;
        Queue<NavState> mQnav = new LinkedList<NavState>();

        LexItr(CharTree<LexEntry> lex, String s, TLRAutomat tlr, boolean full) {
            this.mString = s;
            this.mTLR = tlr;
            this.mFull = full;
            this.mQnav.add(new NavState(new CharTreeNavigator<LexEntry>(lex), 0, 1));
        }

        private void addtoQueue(NavState cur, char c, int state, int add) {
            Iterator<Tuple<Character, Integer>> it = this.mTLR.getCharTrans(Character.valueOf(c), state);
            while (it.hasNext()) {
                NavState next = cur.getNext(it.next(), add);
                if (next == null) continue;
                this.mQnav.add(next);
            }
        }

        @Override
        protected boolean computeNext() {
            if (this.mCurIt != null && this.mCurIt.hasNext()) {
                this.mNext = new Tuple<Integer, LexEntry>(this.mCurPos, this.mCurIt.next());
                return true;
            }
            this.mCurIt = null;
            NavState cur = this.mQnav.poll();
            while (cur != null) {
                int state = cur.mState;
                this.mCurPos = cur.mIndex;
                if (this.mCurPos < this.mString.length()) {
                    this.addtoQueue(cur, '\u0000', state, 0);
                    this.addtoQueue(cur, this.mString.charAt(this.mCurPos), state, 1);
                }
                if (!(state != 1 || this.mCurPos != this.mString.length() && this.mFull)) {
                    this.mCurIt = cur.mNav.iterContent();
                    if (this.mCurIt != null) {
                        this.mNext = new Tuple<Integer, LexEntry>(this.mCurPos, this.mCurIt.next());
                        return true;
                    }
                }
                cur = this.mQnav.poll();
            }
            return false;
        }

        private class NavState {
            int mIndex;
            int mState;
            CharTreeNavigator<LexEntry> mNav;

            NavState(CharTreeNavigator<LexEntry> nav, int index, int state) {
                this.mIndex = index;
                this.mState = state;
                this.mNav = nav;
            }

            NavState getNext(Tuple<Character, Integer> cs, int advance) {
                CharTreeNavigator<LexEntry> nav = new CharTreeNavigator<LexEntry>(this.mNav);
                if (cs.getFirst().charValue() != '\u0000' && !nav.forward(cs.getFirst())) {
                    return null;
                }
                return new NavState(nav, this.mIndex + advance, cs.getSecond());
            }
        }
    }
}

