/*
 * Decompiled with CFR 0.152.
 */
package speeth.lang;

import speeth.lang.Constituent;
import speeth.parser.TreeInfo;
import speeth.parser.TreeNode;

public class LexEntry
implements TreeInfo {
    Constituent mCons;
    String mGraphString;
    String mPhonString = null;
    int mPenalty = 1;
    LexEntry mNext = null;

    public LexEntry(Constituent cons, String graph) {
        this.mCons = cons;
        this.mGraphString = graph;
    }

    public LexEntry(Constituent cons, String graph, String phon, int penalty) {
        this.mCons = cons;
        this.mGraphString = graph;
        this.mPhonString = phon;
        this.mPenalty = penalty;
    }

    public boolean hasPhon() {
        return this.mPhonString != null;
    }

    @Override
    public boolean isTree() {
        return false;
    }

    @Override
    public TreeNode getTree() {
        return null;
    }

    @Override
    public String getGraph() {
        return this.mGraphString;
    }

    @Override
    public String getPhon() {
        return this.mPhonString;
    }

    @Override
    public String getConsName() {
        return this.mCons.getName();
    }

    @Override
    public Constituent getCons() {
        return this.mCons;
    }

    public int getLine() {
        return this.mCons.getLine();
    }

    public void setNextEntry(LexEntry next) {
        this.mNext = next;
    }

    public LexEntry getNextEntry() {
        return this.mNext;
    }

    @Override
    public int getPenalty() {
        return this.mPenalty;
    }

    @Override
    public void setPenalty(int penalty) {
        this.mPenalty = penalty;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(this.mCons.toString());
        s.append(" : ").append(this.mGraphString);
        if (this.hasPhon()) {
            s.append(" ").append(this.mPhonString);
        }
        return s.toString();
    }
}

