/*
 * Decompiled with CFR 0.152.
 */
package speeth.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import speeth.lang.Constituent;
import speeth.lang.GrammarRule;

public class Grammar {
    private String mName;
    private String mStartCons;
    private Map<String, List<GrammarRule>> mRules = new IdentityHashMap<String, List<GrammarRule>>();
    private Set<String> mRecursiveConss = new HashSet<String>();
    private static final List<GrammarRule> EMPTYLIST = new ArrayList<GrammarRule>();

    public Grammar(String name, List<GrammarRule> rules) {
        this.mName = name;
        for (GrammarRule r : rules) {
            String cons = r.getConsName();
            List<GrammarRule> l = this.mRules.get(cons);
            if (l == null) {
                l = new ArrayList<GrammarRule>();
                this.mRules.put(cons, l);
            }
            l.add(r);
        }
        this.mStartCons = rules.get(0).getConsName();
    }

    public void markRecursive(GrammarRule rule) {
        this.mRecursiveConss.add(rule.getConsName());
        rule.markRecursive();
    }

    public boolean isRecursive(String cons) {
        return this.mRecursiveConss.contains(cons);
    }

    public List<GrammarRule> getConsRules(String cons) {
        List<GrammarRule> l = this.mRules.get(cons);
        return l == null ? EMPTYLIST : l;
    }

    public String getStartCons() {
        return this.mStartCons;
    }

    public String getName() {
        return this.mName;
    }

    public boolean check(Collection<Constituent> excons, StringBuffer msg) {
        boolean err = false;
        boolean warn = false;
        HashMap<String, Integer> bodyconss = new HashMap<String, Integer>();
        HashMap<String, Integer> feats = new HashMap<String, Integer>();
        for (List<GrammarRule> lr : this.mRules.values()) {
            for (GrammarRule r : lr) {
                warn |= !r.getCons().check(feats, msg);
                Constituent[] constituentArray = r.getBodyCons();
                int n = constituentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Constituent bs = constituentArray[n2];
                    bodyconss.put(bs.getName(), r.getLine());
                    warn |= !bs.check(feats, msg);
                    ++n2;
                }
            }
        }
        for (Constituent c : excons) {
            warn |= !c.check(feats, msg);
        }
        HashSet<String> exconsstr = new HashSet<String>();
        for (Constituent c : excons) {
            exconsstr.add(c.getName());
        }
        for (String s : bodyconss.keySet()) {
            if (this.mRules.keySet().contains(s) || exconsstr.contains(s)) continue;
            msg.append("Error: line ").append(bodyconss.get(s)).append('\n');
            msg.append("No rule for symbol ").append(s).append(".\n");
            err = true;
        }
        for (String s : this.mRules.keySet()) {
            if (s == this.mStartCons || bodyconss.containsKey(s)) continue;
            msg.append("Warning: line ").append(this.mRules.get(s).get(0).getLine()).append('\n');
            msg.append("Unreachable rule.\n");
            warn = true;
        }
        return !err;
    }

    public String toString() {
        String s = "Grammar \"" + this.mName + "\"";
        for (String cons : this.mRules.keySet()) {
            for (GrammarRule g : this.mRules.get(cons)) {
                s = String.valueOf(s) + "\n\t" + g.toString();
            }
        }
        return s;
    }
}

