/*
 * Decompiled with CFR 0.152.
 */
package speeth.lang;

import java.util.List;
import java.util.Set;
import speeth.lang.Feature;
import speeth.lang.FeatureAtom;
import speeth.lang.FeatureVar;
import speeth.lang.VarList;

public class FeatureTerm
implements Feature {
    Feature[] mFeats;

    public FeatureTerm(List<Feature> subfeats) {
        this.mFeats = subfeats == null ? null : subfeats.toArray(new Feature[0]);
    }

    private FeatureTerm(Feature[] subfeats) {
        this.mFeats = subfeats;
    }

    @Override
    public boolean substAndMatchFeats(VarList subst, Feature feat) {
        return feat.matchFeatList(this.mFeats, subst);
    }

    @Override
    public Feature getSubstitute() {
        return this.copy(true);
    }

    @Override
    public boolean matchAtom(FeatureAtom atom) {
        return false;
    }

    @Override
    public boolean containsdoubleVars(Set<FeatureVar> vars) {
        Feature[] featureArray = this.mFeats;
        int n = this.mFeats.length;
        int n2 = 0;
        while (n2 < n) {
            Feature f = featureArray[n2];
            if (f.containsdoubleVars(vars)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Feature copy(boolean rename) {
        Feature[] newfeats = new Feature[this.mFeats.length];
        int i = 0;
        while (i < this.mFeats.length) {
            newfeats[i] = this.mFeats[i].copy(rename);
            ++i;
        }
        return new FeatureTerm(newfeats);
    }

    @Override
    public Feature copySubst(VarList subst) {
        Feature[] newfeats = new Feature[this.mFeats.length];
        int i = 0;
        while (i < this.mFeats.length) {
            newfeats[i] = this.mFeats[i].copySubst(subst);
            ++i;
        }
        return new FeatureTerm(newfeats);
    }

    @Override
    public boolean matchFeatList(Feature[] feats, VarList subst) {
        if (feats.length != this.mFeats.length) {
            return false;
        }
        int i = 0;
        while (i < feats.length) {
            if (!feats[i].substAndMatchFeats(subst, this.mFeats[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("(");
        String delim = "";
        Feature[] featureArray = this.mFeats;
        int n = this.mFeats.length;
        int n2 = 0;
        while (n2 < n) {
            Feature f = featureArray[n2];
            s.append(delim);
            s.append(f.toString());
            delim = ", ";
            ++n2;
        }
        return s.append(")").toString();
    }

    @Override
    public int getNumSubFeatures() {
        return this.mFeats.length;
    }

    @Override
    public Feature getSubFeature(int i) {
        return this.mFeats[i];
    }
}

