/*
 * Decompiled with CFR 0.152.
 */
package speeth.lang;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import speeth.lang.Feature;
import speeth.lang.FeatureVar;
import speeth.lang.GrammarFileException;
import speeth.lang.VarList;

public class Constituent {
    static Map<String, String> gConsNames = new HashMap<String, String>();
    String mName;
    Feature mFeatures;
    int mLine = -1;

    public Constituent(String name, Feature feat, int line) throws GrammarFileException {
        this.mName = gConsNames.get(name.toUpperCase());
        if (this.mName == null) {
            this.mName = new String(name.toUpperCase());
            gConsNames.put(this.mName, this.mName);
        }
        if (feat != null && feat.containsdoubleVars(new HashSet<FeatureVar>())) {
            throw new GrammarFileException(line, "Constituents containing the same variable twice are currently not supported.");
        }
        this.mFeatures = feat;
        this.mLine = line;
    }

    public boolean substAndMatchFeats(VarList subst, Constituent cons) {
        if (this.mFeatures == null) {
            return cons.mFeatures == null;
        }
        if (cons.mFeatures == null) {
            return false;
        }
        return this.mFeatures.substAndMatchFeats(subst, cons.mFeatures);
    }

    public Constituent copySubst(VarList subst) {
        Constituent c = null;
        try {
            c = new Constituent(this.mName, this.mFeatures == null ? null : this.mFeatures.copySubst(subst), -1);
        }
        catch (GrammarFileException e) {
            throw new IllegalArgumentException("Substituion produced double variables.", e);
        }
        return c;
    }

    public boolean isSimilar(Constituent cons) {
        if (this.mName != cons.mName) {
            return false;
        }
        return this.substAndMatchFeats(new VarList(), cons);
    }

    public String getName() {
        return this.mName;
    }

    public int getLine() {
        return this.mLine;
    }

    public Feature getFeature() {
        return this.mFeatures;
    }

    public boolean isMatchable(Constituent other) {
        return this.mName == other.mName && this.substAndMatchFeats(null, other);
    }

    public boolean check(Map<String, Integer> fmap, StringBuffer msg) {
        int numfeat = this.mFeatures == null ? 0 : this.mFeatures.getNumSubFeatures();
        Integer mapfeat = fmap.get(this.mName);
        if (mapfeat == null) {
            fmap.put(this.mName, numfeat);
            return true;
        }
        if (numfeat != mapfeat) {
            msg.append("Warning: line ").append(this.mLine).append("\n");
            msg.append("feature list of symbol ").append(this.mName).append(" has different length than elsewhere.\n");
            return false;
        }
        return true;
    }

    public String toString() {
        return this.mFeatures == null ? this.mName : String.valueOf(this.mName) + this.mFeatures.toString();
    }

    public static String makeConsName(String name) {
        return gConsNames.get(name.toUpperCase());
    }
}

