/*
 * Decompiled with CFR 0.152.
 */
package speeth.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import speeth.util.CharTree;

public class CharTreeNavigator<T> {
    private CharTree<T> mRoot;
    private CharTree<T> mNode;
    private int mCharPos = 0;

    public CharTreeNavigator(CharTree<T> start) {
        this.mNode = start;
        this.mRoot = start;
    }

    public CharTreeNavigator(CharTreeNavigator<T> start) {
        this.mRoot = start.mRoot;
        this.mNode = start.mNode;
        this.mCharPos = start.mCharPos;
    }

    public void reset() {
        this.mNode = this.mRoot;
        this.mCharPos = 0;
    }

    public boolean forward(Character c) {
        String key = this.mNode.getKey();
        if (this.mCharPos < key.length()) {
            if (key.charAt(this.mCharPos) != c.charValue()) {
                return false;
            }
            ++this.mCharPos;
        } else {
            CharTree<T> newnode = this.mNode.getChild(c);
            if (newnode == null) {
                return false;
            }
            this.mNode = newnode;
            this.mCharPos = 1;
        }
        return true;
    }

    public boolean forward(String s) {
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character c = Character.valueOf(cArray[n2]);
            if (!this.forward(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public List<T> getContent() {
        return this.mNode == null || this.mCharPos < this.mNode.getKey().length() ? null : this.mNode.getContent();
    }

    public List<T> addContent(List<T> list) {
        List<T> cnt;
        if (this.mNode != null && this.mCharPos >= this.mNode.getKey().length() && (cnt = this.mNode.getContent()) != null) {
            if (list == null) {
                list = new ArrayList<T>(cnt);
            } else {
                list.addAll(cnt);
            }
        }
        return list;
    }

    public Iterator<T> iterContent() {
        if (this.mNode != null && this.mCharPos >= this.mNode.getKey().length()) {
            List<T> l = this.mNode.getContent();
            return l == null ? null : l.iterator();
        }
        return null;
    }
}

