/*
 * Decompiled with CFR 0.152.
 */
package speeth.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import speeth.lang.Constituent;
import speeth.lang.Grammar;
import speeth.lang.GrammarRule;
import speeth.lang.VarList;
import speeth.parser.ChartSynTree;
import speeth.parser.TreeInfo;

public class ChartNode {
    Grammar mGrammar;
    Map<String, List<ChartSynTree>> mEdges = new IdentityHashMap<String, List<ChartSynTree>>();
    Set<GrammarRule> mAgenda = new HashSet<GrammarRule>();

    public ChartNode(Grammar gram) {
        this.mGrammar = gram;
    }

    public void addEdge(ChartNode to, TreeInfo info) {
        List<ChartSynTree> l = this.mEdges.get(info.getConsName());
        if (l == null) {
            l = new ArrayList<ChartSynTree>();
            this.mEdges.put(info.getConsName(), l);
        }
        l.add(new ChartSynTree(info.getCons(), info, VarList.EMPTYLIST, to));
    }

    public List<ChartSynTree> getConsSynTrees(String cons) {
        return this.getChartConsTrees(cons, false);
    }

    private List<ChartSynTree> addToSynTreeList(Constituent cons, List<ChartSynTree> list, boolean retry) {
        ArrayList<ChartSynTree> cur = new ArrayList<ChartSynTree>();
        for (ChartSynTree ctree : list) {
            for (ChartSynTree match : ctree.getEndNode().getChartConsTrees(cons.getName(), retry)) {
                VarList subst = new VarList(ctree.getSubst());
                if (!cons.substAndMatchFeats(subst, match.getCons())) continue;
                cur.add(new ChartSynTree(subst, ctree, match));
            }
        }
        return cur;
    }

    private List<ChartSynTree> getSynTreesForRule(GrammarRule rule, boolean retry) {
        List<ChartSynTree> rlist = null;
        rlist = new ArrayList<ChartSynTree>();
        ChartSynTree empty = new ChartSynTree(VarList.EMPTYLIST);
        empty.setEndNode(this);
        rlist.add(empty);
        this.mAgenda.add(rule);
        Constituent[] constituentArray = rule.getBodyCons();
        int n = constituentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constituent cons = constituentArray[n2];
            rlist = this.addToSynTreeList(cons, rlist, retry);
            retry = false;
            ++n2;
        }
        this.mAgenda.remove(rule);
        ListIterator it = rlist.listIterator();
        while (it.hasNext()) {
            ChartSynTree s = (ChartSynTree)it.next();
            s.setRule(rule);
            if (!s.isCyclic()) continue;
            it.remove();
        }
        return rlist;
    }

    private List<ChartSynTree> getChartConsTrees(String cons, boolean retry) {
        List<ChartSynTree> rl = this.mEdges.get(cons);
        if (rl != null && !retry) {
            return rl;
        }
        boolean recurse = false;
        ArrayList<ChartSynTree> nonrec = new ArrayList<ChartSynTree>();
        do {
            ArrayList<ChartSynTree> newl = new ArrayList<ChartSynTree>();
            for (GrammarRule rule : this.mGrammar.getConsRules(cons)) {
                if (recurse && !rule.isRecursive()) continue;
                if (this.mAgenda.contains(rule)) {
                    this.mGrammar.markRecursive(rule);
                    continue;
                }
                List<ChartSynTree> ret = this.getSynTreesForRule(rule, recurse);
                if (rule.isRecursive()) {
                    newl.addAll(ret);
                    continue;
                }
                nonrec.addAll(ret);
            }
            boolean listGrows = rl == null || rl.size() < newl.size() + nonrec.size();
            boolean bl = recurse = newl.size() > 0 && listGrows;
            if (!listGrows) continue;
            newl.addAll(nonrec);
            this.mEdges.put(cons, newl);
            rl = newl;
        } while (recurse);
        return rl;
    }
}

