/*
 * Decompiled with CFR 0.152.
 */
package speeth.output.parsegui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import speeth.output.parsegui.NodeBox;

public class StringNodeBox
implements NodeBox {
    private List<StringLine> mstrings = new ArrayList<StringLine>();

    @Override
    public int getBoxWidth() {
        int length = 0;
        for (StringLine s : this.mstrings) {
            length = Math.max(s.mTextWidth, length);
        }
        return length;
    }

    @Override
    public int getBoxHeight() {
        int n = this.mstrings.size() - 1;
        StringLine last = this.mstrings.get(n);
        return last.mYPos - this.mstrings.get((int)0).mYPos + last.mTextHeight + last.mGap;
    }

    @Override
    public int getBaseLine() {
        return this.mstrings.get((int)0).mYPos + this.mstrings.get((int)0).mTextHeight / 2 + 3 * this.mstrings.get((int)0).mGap / 2;
    }

    @Override
    public int getBaseLineOffset() {
        return this.mstrings.get((int)0).mTextWidth / 2;
    }

    @Override
    public void updatexPos(int x) {
        for (StringLine s : this.mstrings) {
            s.mXPos = x - s.mTextWidth / 2;
        }
    }

    @Override
    public void updateyPos(int y) {
        for (StringLine s : this.mstrings) {
            s.mYPos = y;
            y += s.mTextHeight;
        }
    }

    public void addString(String s, Color color) {
        if (!s.isEmpty()) {
            this.mstrings.add(new StringLine(s, color, 0.0f, 20));
        }
    }

    public void addString(String s, Color color, float fontsz, int pregap) {
        if (!s.isEmpty()) {
            this.mstrings.add(new StringLine(s, color, fontsz, pregap));
        }
    }

    @Override
    public void draw(Graphics2D g) {
        FontRenderContext frc = g.getFontRenderContext();
        Color color = g.getColor();
        Font font = g.getFont();
        for (StringLine s : this.mstrings) {
            TextLayout layout = new TextLayout(s.mText, s.mFont, frc);
            g.setColor(s.mColor);
            layout.draw(g, s.mXPos, (float)s.mYPos + layout.getAscent() + (float)s.mGap);
        }
        g.setColor(color);
        g.setFont(font);
    }

    private class StringLine {
        public String mText;
        public Color mColor;
        public Font mFont;
        public int mGap;
        public int mTextHeight;
        public int mTextWidth;
        public int mXPos;
        public int mYPos;

        public StringLine(String text, Color color, float fontsz, int gap) {
            this.mText = text;
            this.mColor = color;
            this.mGap = gap;
            BufferedImage buffer = new BufferedImage(1, 1, 1);
            Graphics2D g2 = buffer.createGraphics();
            this.mFont = g2.getFont();
            if (fontsz != 0.0f) {
                this.mFont = this.mFont.deriveFont((float)this.mFont.getSize() + fontsz);
            }
            FontRenderContext frc = g2.getFontRenderContext();
            TextLayout layout = new TextLayout(text, this.mFont, frc);
            this.mTextHeight = (int)layout.getBounds().getHeight() + gap;
            this.mTextWidth = (int)layout.getBounds().getWidth();
        }
    }
}

