/*
 * Decompiled with CFR 0.152.
 */
package speeth.transducer;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import speeth.lang.EncodingException;
import speeth.lang.TLRAutomat;
import speeth.util.ComputingIterator;
import speeth.util.Tuple;

public class Transducer
implements Iterable<String> {
    private TLRAutomat mTLR;
    private Deque<TransState> mQueue = new LinkedList<TransState>();
    private Deque<Tuple<String, Integer>> mDoneStates = new LinkedList<Tuple<String, Integer>>();
    private StringBuilder mProcessedString = new StringBuilder();
    private boolean mDoDecode = false;

    public Transducer(TLRAutomat tlr) {
        this.mTLR = tlr;
        this.mDoneStates.add(new Tuple<String, Integer>("", 1));
    }

    public Transducer(TLRAutomat tlr, boolean dodecode) {
        this.mTLR = tlr;
        this.mDoneStates.add(new Tuple<String, Integer>("", 1));
        this.mDoDecode = dodecode;
    }

    public void feed(String inp) {
        if (inp != null && inp.length() > 0) {
            this.mProcessedString.append(inp);
            assert (this.mQueue.size() == 0);
            Tuple<String, Integer> ts = this.mDoneStates.poll();
            while (ts != null) {
                Iterator<Tuple<Character, Integer>> it = this.mTLR.getCharTrans(Character.valueOf(inp.charAt(0)), ts.getSecond());
                if (it.hasNext()) {
                    this.mQueue.add(new TransState(1, ts.getFirst(), it));
                }
                if ((it = this.mTLR.getCharTrans(Character.valueOf('\u0000'), ts.getSecond())).hasNext()) {
                    this.mQueue.add(new TransState(0, ts.getFirst(), it));
                }
                ts = this.mDoneStates.poll();
            }
            this.computeNext(inp);
        }
    }

    public void feedEncode(String inp) throws EncodingException {
        this.feed(this.mTLR.getAlphabet().encode(inp));
    }

    public void appendString(String inp) throws EncodingException {
        String s = this.mDoDecode ? inp : this.mTLR.getAlphabet().encode(inp);
        for (Tuple<String, Integer> ts : this.mDoneStates) {
            ts.setFirst(String.valueOf(ts.getFirst()) + s);
        }
    }

    public String getProcessedString() {
        return this.mProcessedString.toString();
    }

    private String convertOutChar(char c) {
        String s;
        try {
            s = this.mDoDecode ? this.mTLR.getAlphabet().decodeChar(c) : Character.toString(c);
        }
        catch (EncodingException e) {
            throw new RuntimeException("Could not decode the character I just encoded. That should not happen.");
        }
        return s;
    }

    private boolean computeNext(String inp) {
        TransState cur = this.mQueue.poll();
        while (cur != null) {
            Iterator<Tuple<Character, Integer>> it;
            String nstr;
            Tuple<Character, Integer> t = cur.mIt.next();
            String string = nstr = t.getFirst().compareTo(Character.valueOf('\u0000')) == 0 ? cur.mOut : String.valueOf(cur.mOut) + this.convertOutChar(t.getFirst().charValue());
            if (cur.mPos == inp.length()) {
                this.mDoneStates.add(new Tuple<String, Integer>(nstr, t.getSecond()));
            } else {
                it = this.mTLR.getCharTrans(Character.valueOf(inp.charAt(cur.mPos)), t.getSecond());
                if (it.hasNext()) {
                    this.mQueue.addFirst(new TransState(cur.mPos + 1, nstr, it));
                }
            }
            it = this.mTLR.getCharTrans(Character.valueOf('\u0000'), t.getSecond());
            if (it.hasNext()) {
                this.mQueue.add(new TransState(cur.mPos, nstr, it));
            }
            if (cur.mIt.hasNext()) {
                this.mQueue.add(cur);
            }
            cur = this.mQueue.poll();
        }
        return false;
    }

    public void reset() {
        for (Tuple<String, Integer> ts : this.mDoneStates) {
            ts.setSecond(1);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new TransducerResultIterator(this.mDoneStates);
    }

    private class TransState {
        int mPos;
        String mOut;
        Iterator<Tuple<Character, Integer>> mIt;

        TransState(int pos, String out, Iterator<Tuple<Character, Integer>> it) {
            this.mPos = pos;
            this.mOut = out;
            this.mIt = it;
        }
    }

    private class TransducerResultIterator
    extends ComputingIterator<String> {
        private Iterator<Tuple<String, Integer>> mList;

        public TransducerResultIterator(Iterable<Tuple<String, Integer>> list) {
            this.mList = list.iterator();
        }

        @Override
        protected boolean computeNext() {
            Tuple<String, Integer> t = null;
            while (t == null && this.mList.hasNext()) {
                t = this.mList.next();
                if (t.getSecond() == 1) continue;
                t = null;
            }
            if (t != null) {
                this.mNext = (String)t.getFirst();
                return true;
            }
            return false;
        }
    }
}

