/*
 * Decompiled with CFR 0.152.
 */
package speeth.parser;

import java.util.Comparator;
import java.util.TreeSet;
import speeth.lang.AnalysisException;
import speeth.lang.Constituent;
import speeth.lang.Grammar;
import speeth.lang.VarList;
import speeth.parser.ChartParser;
import speeth.parser.SynTree;
import speeth.parser.TreeInfo;
import speeth.parser.WordAnalyser;

public class SentenceAnalyser {
    Grammar mGrammar;
    WordAnalyser mWordAna;
    static final Comparator<SynTree> PENALTY_ORDER = new Comparator<SynTree>(){

        @Override
        public int compare(SynTree e1, SynTree e2) {
            if (e1.getPenalty() == e2.getPenalty()) {
                return 1;
            }
            return e1.getPenalty() - e2.getPenalty();
        }
    };

    public SentenceAnalyser(Grammar sgram, WordAnalyser wana) {
        this.mGrammar = sgram;
        this.mWordAna = wana;
    }

    public Iterable<SynTree> analyse(String phrase) throws AnalysisException {
        return this.analyse(null, phrase);
    }

    public Iterable<SynTree> analyse(String cons, String phrase) throws AnalysisException {
        String[] tokens = phrase.trim().split("\\s+");
        TreeSet<SynTree> ret = new TreeSet<SynTree>(PENALTY_ORDER);
        if (cons == null || this.mGrammar.getConsRules(Constituent.makeConsName(cons)).size() > 0) {
            ChartParser parser = new ChartParser(this.mGrammar, tokens.length + 1);
            int i = 0;
            while (i < tokens.length) {
                parser.initEdges(i, 1, this.mWordAna.analyse(tokens[i]));
                ++i;
            }
            parser.parse(ret, cons, false);
        } else if (tokens.length == 1) {
            for (TreeInfo t : this.mWordAna.analyse(cons, tokens[0])) {
                ret.add(new SynTree(t.getCons(), t, VarList.EMPTYLIST));
            }
        } else {
            throw new AnalysisException(String.format("Start symbol '%s' not found in sentence grammar and there is more than one terminal symbol to analyse.", cons));
        }
        return ret;
    }

    public boolean check(StringBuffer msg) {
        boolean ret = this.mWordAna.check(msg);
        ret = ret && this.mGrammar.check(this.mWordAna.getRootSymbols(), msg);
        return ret;
    }
}

