/*
 * Decompiled with CFR 0.152.
 */
package speeth.parser;

import java.util.Collection;
import java.util.List;
import speeth.lang.Constituent;
import speeth.lang.Grammar;
import speeth.lang.GrammarFileException;
import speeth.parser.ChartNode;
import speeth.parser.ChartSynTree;
import speeth.parser.SynTree;
import speeth.parser.TreeInfo;

public class ChartParser {
    Grammar mGrammar;
    ChartNode[] mChart;

    public ChartParser(Grammar gram, int size) {
        this.mGrammar = gram;
        this.mChart = new ChartNode[size];
    }

    private ChartNode getChartNode(int i) {
        ChartNode node = this.mChart[i];
        if (node == null) {
            this.mChart[i] = node = new ChartNode(this.mGrammar);
        }
        return node;
    }

    public void initEdge(int from, int len, TreeInfo info) {
        this.getChartNode(from).addEdge(this.getChartNode(from + len), info);
    }

    public void initEdges(int from, int len, Iterable<? extends TreeInfo> info) {
        ChartNode f = this.getChartNode(from);
        ChartNode t = this.getChartNode(from + len);
        for (TreeInfo treeInfo : info) {
            f.addEdge(t, treeInfo);
        }
    }

    public void parse(Collection<? super SynTree> results, String cons, boolean isPseudoRoot) throws GrammarFileException {
        if (results == null) {
            throw new IllegalArgumentException("Result list not initialised.");
        }
        if (this.mChart[0] != null) {
            String scons;
            String string = scons = cons == null ? this.mGrammar.getStartCons() : Constituent.makeConsName(cons);
            if (scons == null) {
                throw new GrammarFileException(-1, "Start symbol '" + cons + "' does not exist.");
            }
            List<ChartSynTree> trees = this.mChart[0].getConsSynTrees(scons);
            ChartNode end = this.mChart[this.mChart.length - 1];
            for (ChartSynTree t : trees) {
                if (t.getEndNode() != end) continue;
                results.add(isPseudoRoot ? t.getChild(0) : t);
            }
        }
    }
}

